/*
 * Decompiled with CFR 0.152.
 */
package com.tpwar.tutorial;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.tpwar.domain.Model;
import com.tpwar.domain.avatar.AvatarTutorialData;
import com.tpwar.events.EventListener;
import com.tpwar.game.battle.Battlefield;
import com.tpwar.game.battle.units.Unit;
import com.tpwar.game.hud.BattleHud;
import com.tpwar.game.maps.TutorialPoint;
import com.tpwar.game.screens.BattleScreen;
import com.tpwar.game.utils.Assets;
import com.tpwar.game.windows.GameWindow;
import com.tpwar.game.windows.WindowManager;
import com.tpwar.game.windows.tutorial.TutorialWindow;
import com.tpwar.storage.Storage;
import com.tpwar.storage.tutorial.TutorialData;
import com.tpwar.storage.tutorial.TutorialStepData;

public class BattleTutorial
extends InputAdapter
implements Disposable {
    private final WindowManager windowManager = WindowManager.getInstance();
    private final Model model = Model.getInstance();
    private final Storage storage = Storage.getInstance();
    private final Battlefield battlefield;
    private final BattleHud hud;
    private final Array<Actor> targets = new Array(10);
    private final Array<String> hints = new Array(10);
    private boolean needListenRound = true;
    private boolean needShowHint = false;
    private Vector3 point = new Vector3();
    private boolean clickDownOnTarget;
    private TutorialPoint tutorialPoint;

    public BattleTutorial(BattleScreen screen) {
        this.battlefield = screen.getBattlefield();
        this.hud = screen.getHud();
        this.tutorialPoint = new TutorialPoint();
        this.windowManager.addListener(2, new EventListener<GameWindow>(){

            @Override
            public void onEvent(int type, GameWindow data) {
                BattleTutorial.this.nextStep();
                BattleTutorial.this.windowManager.removeListener(this);
            }
        });
        this.battlefield.getDispatcher().addListener(13, new EventListener<Boolean>(){

            @Override
            public void onEvent(int type, Boolean data) {
                if (BattleTutorial.this.needListenRound) {
                    BattleTutorial.this.needListenRound = false;
                    BattleTutorial.this.nextStep();
                }
            }
        });
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        boolean tutorialWnd = this.windowManager.hasOpenedWindowByClass(TutorialWindow.class);
        Actor target = this.getCurrentTarget();
        boolean clickOnTarget = false;
        this.clickDownOnTarget = false;
        if (target != null) {
            boolean bl = clickOnTarget = !tutorialWnd && this.checkClickOnTarget(target, screenX, screenY);
            if (clickOnTarget && target instanceof Unit) {
                this.clickOnTarget();
                this.clickDownOnTarget = false;
            } else {
                this.clickDownOnTarget = true;
            }
        }
        return !clickOnTarget && !this.windowManager.hasOpenedWindow();
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        boolean tutorialWnd = this.windowManager.hasOpenedWindowByClass(TutorialWindow.class);
        Actor target = this.getCurrentTarget();
        boolean clickOnTarget = false;
        if (target != null && !(target instanceof Unit)) {
            boolean bl = clickOnTarget = !tutorialWnd && this.checkClickOnTarget(target, screenX, screenY);
            if (clickOnTarget && this.clickDownOnTarget) {
                this.clickOnTarget();
            }
        }
        if (this.needShowHint) {
            String hintText = this.hints.removeIndex(0);
            this.showHint(hintText);
            this.needShowHint = false;
        }
        return super.touchUp(screenX, screenY, pointer, button);
    }

    private void clickOnTarget() {
        this.targets.removeIndex(0);
        if (this.targets.size == 0) {
            this.hidePointer();
            this.needListenRound = true;
            AvatarTutorialData tutorial = this.model.player.selectedAvatar.getCurrentTutorial();
            TutorialStepData tutorialStep = this.storage.tutorialStep.get(tutorial.tutorialStepId);
            if (tutorialStep.isFinishStep()) {
                tutorial.completed = true;
            }
        } else if (this.getCurrentTarget() != null) {
            if (this.hints.size > 0) {
                this.needShowHint = true;
                this.hidePointer();
            } else {
                this.showPoint(this.getCurrentTarget());
            }
        }
    }

    private boolean checkClickOnTarget(Actor target, int screenX, int screenY) {
        target.getStage().getViewport().unproject(this.point.set(screenX, screenY, 0.0f));
        if (target instanceof Unit) {
            Vector2 stageCoords = new Vector2(screenX, screenY);
            target.getParent().screenToLocalCoordinates(stageCoords);
            return ((Unit)target).contains(stageCoords.x, stageCoords.y);
        }
        return target.getStage().hit(this.point.x, this.point.y, true) == target;
    }

    private void showPoint(Object target) {
        Actor actor = (Actor)target;
        float centerX = actor.getWidth() / 2.0f;
        float centerY = actor.getHeight() / 2.0f;
        Vector2 temp = new Vector2(centerX, centerY);
        actor.localToStageCoordinates(temp);
        actor.getStage().addActor(this.tutorialPoint);
        if (actor instanceof Unit) {
            temp.add(0.0f, 50.0f);
        }
        this.tutorialPoint.setPosition(temp.x - this.tutorialPoint.getWidth() / 2.0f, temp.y - this.tutorialPoint.getHeight() / 2.0f);
        this.tutorialPoint.play();
    }

    private void showHint(String hintText) {
        final TutorialWindow wnd = new TutorialWindow(Assets.getInstance().getDefaultSkin(), hintText);
        wnd.getCloseButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                BattleTutorial.this.hideHint();
                wnd.closeHandler();
            }
        });
        this.windowManager.open(wnd, true);
    }

    private void hideHint() {
        if (this.getCurrentTarget() != null) {
            this.showPoint(this.getCurrentTarget());
        }
    }

    private void hidePointer() {
        this.tutorialPoint.stop();
        this.tutorialPoint.remove();
    }

    private Actor getCurrentTarget() {
        return this.targets.size > 0 ? this.targets.get(0) : null;
    }

    public void nextStep() {
        AvatarTutorialData tutorial = this.model.player.selectedAvatar.getCurrentTutorial();
        TutorialData tutorialData = this.storage.tutorial.get(tutorial.tutorialId);
        if (!tutorialData.isBattleTutorial()) {
            return;
        }
        if (tutorial.completed) {
            Gdx.app.log(this.getClass().getSimpleName(), "battle tutorial completed");
            return;
        }
        TutorialStepData step = this.storage.tutorialStep.get(tutorial.tutorialStepId);
        if (step.isFinishStep()) {
            tutorial.completed = true;
        }
        switch (step.step) {
            case 1: {
                this.showTutorialStep2();
                break;
            }
            case 2: {
                this.showTutorialStep3();
                break;
            }
            case 3: {
                this.showTutorialStep4();
                break;
            }
            case 4: {
                this.showTutorialStep5();
                break;
            }
            case 5: {
                this.showTutorialStep6();
                break;
            }
        }
        TutorialStepData nextStep = this.storage.tutorialStep.getNextTutorialStep(tutorial.tutorialId, tutorial.tutorialStepId);
        if (nextStep != null) {
            tutorial.tutorialStepId = nextStep.id;
        }
        if (nextStep == null) {
            this.hidePointer();
        }
    }

    private void showTutorialStep6() {
        this.targets.add(this.battlefield.getBottomUnitBySlot(3), this.battlefield.getTopUnitBySlot(3), this.hud.bottomPanel.startRoundBtn);
        this.showHint(this.model.lang.get("tutorial.battle.step6"));
    }

    private void showTutorialStep5() {
        this.targets.add(this.battlefield.getBottomUnitBySlot(3), this.battlefield.getTopUnitBySlot(3), this.hud.bottomPanel.startRoundBtn);
        this.showHint(this.model.lang.get("tutorial.battle.step5"));
    }

    private void showTutorialStep4() {
        this.targets.add(this.battlefield.getBottomUnitBySlot(2), this.battlefield.getTopUnitBySlot(1), this.hud.bottomPanel.startRoundBtn);
        this.showHint(this.model.lang.get("tutorial.battle.step4"));
    }

    private void showTutorialStep3() {
        this.targets.add(this.battlefield.getBottomUnitBySlot(2), this.battlefield.getTopUnitBySlot(1), this.battlefield.getBottomUnitBySlot(3), this.battlefield.getTopUnitBySlot(2));
        this.targets.add(this.hud.bottomPanel.startRoundBtn);
        this.showHint(this.model.lang.get("tutorial.battle.step3"));
    }

    private void showTutorialStep2() {
        this.targets.add(this.battlefield.getBottomUnitBySlot(1), this.battlefield.getTopUnitBySlot(2), this.hud.bottomPanel.startRoundBtn);
        this.hints.add(this.model.lang.get("tutorial.battle.step2"));
        this.showHint(this.model.lang.get("tutorial.battle.info"));
    }

    @Override
    public void dispose() {
        this.tutorialPoint.stop();
    }
}

