/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx;

import com.badlogic.gdx.utils.Array;

public abstract class Multiplexer<T> {
    protected final Array<T> receivers;

    public Multiplexer() {
        this.receivers = new Array();
    }

    public Multiplexer(int size) {
        this.receivers = new Array(size);
    }

    @SafeVarargs
    public Multiplexer(T ... receivers) {
        this.receivers = new Array<T>(receivers);
    }

    public Multiplexer(Array<T> receivers) {
        this.receivers = new Array<T>(receivers);
    }

    public void add(T receiver) {
        this.receivers.add(receiver);
    }

    public boolean remove(T receiver) {
        return this.receivers.removeValue(receiver, true);
    }

    public void clear() {
        this.receivers.clear();
    }

    public int size() {
        return this.receivers.size;
    }

    public void setReceivers(Array<T> receivers) {
        this.receivers.clear();
        this.receivers.addAll(receivers);
    }

    public void setReceivers(T ... receivers) {
        this.receivers.clear();
        this.receivers.addAll(receivers);
    }

    public Array<T> getReceivers() {
        return this.receivers;
    }
}

