/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class AnnotationAssetManager
extends AssetManager {
    private static Object get(Field field, Object container) {
        if (container == null && !field.isStatic()) {
            throw new IllegalArgumentException("field is not static but container instance is null: " + field.getName());
        }
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        Object obj = null;
        try {
            obj = field.get(container);
        }
        catch (ReflectionException e) {
            Gdx.app.error("AnnotationAssetManager", "could not access " + field, e);
        }
        if (!accessible) {
            field.setAccessible(false);
        }
        return obj;
    }

    private static Object invoke(Method method, Object container, Object ... parameters) {
        if (container == null && !method.isStatic()) {
            throw new IllegalArgumentException("method is not static but container instance is null: " + method.getName());
        }
        boolean accessible = method.isAccessible();
        if (!accessible) {
            method.setAccessible(true);
        }
        Object obj = null;
        try {
            obj = method.invoke(container, parameters);
        }
        catch (ReflectionException e) {
            Gdx.app.error("AnnotationAssetManager", "could not invoke " + method, e);
        }
        if (!accessible) {
            method.setAccessible(false);
        }
        return obj;
    }

    private static String getAssetPath(Object pathObj) {
        if (pathObj instanceof FileHandle) {
            return ((FileHandle)pathObj).path();
        }
        if (pathObj instanceof AssetDescriptor) {
            return ((AssetDescriptor)pathObj).fileName;
        }
        return pathObj.toString();
    }

    private static Class getAssetType(Asset asset, Object pathObj) {
        if (pathObj instanceof AssetDescriptor) {
            return ((AssetDescriptor)pathObj).type;
        }
        return asset.value();
    }

    private static AssetLoaderParameters getAssetLoaderParameters(Asset asset, Object pathObj, Class containerType, Object container) {
        Class clazz;
        String name;
        if (pathObj instanceof AssetDescriptor) {
            return ((AssetDescriptor)pathObj).params;
        }
        if (asset.param().length() == 0) {
            return null;
        }
        String location = asset.param();
        boolean method = location.endsWith("()");
        if (location.contains(".")) {
            int end = location.lastIndexOf(46);
            String className = location.substring(0, end);
            name = location.substring(end + 1, method ? location.lastIndexOf("()") : 0);
            try {
                clazz = ClassReflection.forName(className);
            }
            catch (ReflectionException e) {
                throw new IllegalArgumentException("Failed to load AssetLoaderParameters from " + location + ": class " + className + " does not exist");
            }
        } else {
            clazz = containerType;
            String string = name = method ? location.substring(0, location.lastIndexOf("()")) : location;
        }
        if (method) {
            boolean withParams;
            Method m;
            try {
                m = ClassReflection.getDeclaredMethod(clazz, name, Class.class, String.class, Object.class);
                withParams = true;
            }
            catch (ReflectionException e) {
                try {
                    m = ClassReflection.getDeclaredMethod(clazz, name, new Class[0]);
                    withParams = false;
                }
                catch (ReflectionException e1) {
                    throw new GdxRuntimeException("failed to access method " + name, e1);
                }
            }
            if (!ClassReflection.isAssignableFrom(AssetLoaderParameters.class, m.getReturnType())) {
                throw new IllegalArgumentException("AssetLoaderParameters supplier method does not return AssetLoaderParameters: " + m.getReturnType());
            }
            if (withParams) {
                return (AssetLoaderParameters)AnnotationAssetManager.invoke(m, container, AnnotationAssetManager.getAssetType(asset, pathObj), AnnotationAssetManager.getAssetPath(pathObj), pathObj);
            }
            return (AssetLoaderParameters)AnnotationAssetManager.invoke(m, container, new Object[0]);
        }
        try {
            Field f = ClassReflection.getDeclaredField(clazz, name);
            return (AssetLoaderParameters)AnnotationAssetManager.get(f, container);
        }
        catch (ReflectionException e) {
            throw new GdxRuntimeException("failed to access field " + name, e);
        }
    }

    public static String getAssetPath(Field field, Object container) {
        return AnnotationAssetManager.getAssetPath(AnnotationAssetManager.get(field, container));
    }

    public static String getAssetPath(Field field) {
        return AnnotationAssetManager.getAssetPath(field, null);
    }

    public static String getAssetPath(Method method, Object container) {
        return AnnotationAssetManager.getAssetPath(AnnotationAssetManager.invoke(method, container, new Object[0]));
    }

    public static String getAssetPath(Method method) {
        return AnnotationAssetManager.getAssetPath(method, null);
    }

    public static Class getAssetType(Field field, Object container) {
        return AnnotationAssetManager.getAssetType(field.isAnnotationPresent(Asset.class) ? field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class) : null, AnnotationAssetManager.get(field, container));
    }

    public static Class getAssetType(Field field) {
        return AnnotationAssetManager.getAssetType(field, null);
    }

    public static Class getAssetType(Method method, Object container) {
        return AnnotationAssetManager.getAssetType(method.isAnnotationPresent(Asset.class) ? method.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class) : null, AnnotationAssetManager.invoke(method, container, new Object[0]));
    }

    public static Class getAssetType(Method method) {
        return AnnotationAssetManager.getAssetType(method, null);
    }

    public static AssetLoaderParameters getAssetLoaderParameters(Field field, Object container) {
        return AnnotationAssetManager.getAssetLoaderParameters(field.isAnnotationPresent(Asset.class) ? field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class) : null, AnnotationAssetManager.get(field, container), field.getDeclaringClass(), container);
    }

    public static AssetLoaderParameters getAssetLoaderParameters(Field field) {
        return AnnotationAssetManager.getAssetLoaderParameters(field, null);
    }

    public static AssetLoaderParameters getAssetLoaderParameters(Method method, Object container) {
        return AnnotationAssetManager.getAssetLoaderParameters(method.isAnnotationPresent(Asset.class) ? method.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class) : null, AnnotationAssetManager.invoke(method, container, new Object[0]), method.getDeclaringClass(), container);
    }

    public static AssetLoaderParameters getAssetLoaderParameters(Method method) {
        return AnnotationAssetManager.getAssetLoaderParameters(method, null);
    }

    public static <T> AssetDescriptor<T> createAssetDescriptor(Field field, Object container) {
        Object pathObj = AnnotationAssetManager.get(field, container);
        if (pathObj instanceof AssetDescriptor) {
            return (AssetDescriptor)pathObj;
        }
        if (!field.isAnnotationPresent(Asset.class)) {
            throw new IllegalArgumentException("cannot create an AssetDescriptor from a field not annotated with @Asset");
        }
        Asset asset = field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class);
        return new AssetDescriptor(AnnotationAssetManager.getAssetPath(pathObj), AnnotationAssetManager.getAssetType(asset, pathObj), AnnotationAssetManager.getAssetLoaderParameters(asset, pathObj, field.getDeclaringClass(), container));
    }

    public static <T> AssetDescriptor<T> createAssetDescriptor(Field field) {
        return AnnotationAssetManager.createAssetDescriptor(field, null);
    }

    public static <T> AssetDescriptor<T> createAssetDescriptor(Method method, Object container) {
        Object pathObj = AnnotationAssetManager.invoke(method, container, new Object[0]);
        if (pathObj instanceof AssetDescriptor) {
            return (AssetDescriptor)pathObj;
        }
        if (!method.isAnnotationPresent(Asset.class)) {
            throw new IllegalArgumentException("cannot create an AssetDescriptor from a method not annotated with @Asset");
        }
        Asset asset = method.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class);
        return new AssetDescriptor(AnnotationAssetManager.getAssetPath(pathObj), AnnotationAssetManager.getAssetType(asset, pathObj), AnnotationAssetManager.getAssetLoaderParameters(asset, pathObj, method.getDeclaringClass(), container));
    }

    public static <T> AssetDescriptor<T> createAssetDescriptor(Method method) {
        return AnnotationAssetManager.createAssetDescriptor(method, null);
    }

    public AnnotationAssetManager() {
    }

    public AnnotationAssetManager(FileHandleResolver resolver) {
        super(resolver);
    }

    public AnnotationAssetManager(FileHandleResolver resolver, boolean defaultLoaders) {
        super(resolver, defaultLoaders);
    }

    private void load(Asset asset, Object pathObj, Class<?> containerType, Object container) {
        if (pathObj instanceof Object[]) {
            Object[] pathObjs;
            for (Object path : pathObjs = (Object[])pathObj) {
                this.load(asset, path, containerType, container);
            }
        } else {
            this.load(AnnotationAssetManager.getAssetPath(pathObj), AnnotationAssetManager.getAssetType(asset, pathObj), AnnotationAssetManager.getAssetLoaderParameters(asset, pathObj, containerType, container));
        }
    }

    private <T> void load(Class<T> container, T instance) {
        Asset asset;
        for (Method method : ClassReflection.getDeclaredMethods(container)) {
            if (!method.isAnnotationPresent(Asset.class) || !(asset = method.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class)).load()) continue;
            this.load(method, instance);
        }
        for (Field field : ClassReflection.getDeclaredFields(container)) {
            if (!field.isAnnotationPresent(Asset.class) || !(asset = field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class)).load()) continue;
            this.load(field, instance);
        }
    }

    public <T> void load(T container) {
        this.load(container.getClass(), container);
    }

    public void load(Class<?> container) {
        this.load(container, null);
    }

    public void load(Field field, Object container) {
        this.load(field.isAnnotationPresent(Asset.class) ? field.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class) : null, AnnotationAssetManager.get(field, container), field.getDeclaringClass(), container);
    }

    public void load(Field field) {
        this.load(field, null);
    }

    public void load(Method method, Object container) {
        if (method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException(method.getName() + " takes parameters. Methods that take parameters are not supported.");
        }
        if (method.getReturnType().isPrimitive()) {
            throw new IllegalArgumentException(method.getName() + " returns " + method.getReturnType() + ". Methods that return primitives are not supported.");
        }
        this.load(method.isAnnotationPresent(Asset.class) ? method.getDeclaredAnnotation(Asset.class).getAnnotation(Asset.class) : null, AnnotationAssetManager.invoke(method, container, new Object[0]), method.getDeclaringClass(), container);
    }

    public void load(Method method) {
        this.load(method, null);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Asset {
        public boolean load() default true;

        public Class<?> value() default void.class;

        public String param() default "";
    }
}

