/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.math;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.Ellipse;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.ShortArray;
import net.dermetfan.gdx.math.BayazitDecomposer;
import net.dermetfan.gdx.math.MathUtils;
import net.dermetfan.gdx.utils.ArrayUtils;

public class GeometryUtils
extends net.dermetfan.utils.math.GeometryUtils {
    private static final Vector2 vec2_0 = new Vector2();
    private static Array<Vector2> tmpVector2Array = new Array();
    private static final FloatArray tmpFloatArray = new FloatArray();

    public static boolean between(Vector2 point, Vector2 a, Vector2 b, boolean inclusive) {
        return GeometryUtils.between(point.x, point.y, a.x, a.y, b.x, b.y, inclusive);
    }

    public static boolean between(Vector2 point, Vector2 a, Vector2 b) {
        return GeometryUtils.between(point.x, point.y, a.x, a.y, b.x, b.y);
    }

    public static Vector2 abs(Vector2 vector) {
        vector.x = Math.abs(vector.x);
        vector.y = Math.abs(vector.y);
        return vector;
    }

    public static Vector3 abs(Vector3 vector) {
        vector.x = Math.abs(vector.x);
        vector.y = Math.abs(vector.y);
        vector.z = Math.abs(vector.z);
        return vector;
    }

    public static Array<Vector2> add(Array<Vector2> vertices, float x, float y) {
        for (Vector2 vertice : vertices) {
            vertice.add(x, y);
        }
        return vertices;
    }

    public static Array<Vector2> sub(Array<Vector2> vertices, float x, float y) {
        return GeometryUtils.add(vertices, -x, -y);
    }

    public static FloatArray add(FloatArray vertices, float x, float y) {
        GeometryUtils.add(vertices.items, 0, vertices.size, x, y);
        return vertices;
    }

    public static FloatArray sub(FloatArray vertices, float x, float y) {
        GeometryUtils.sub(vertices.items, 0, vertices.size, x, y);
        return vertices;
    }

    public static FloatArray addX(FloatArray vertices, float value) {
        GeometryUtils.addX(vertices.items, 0, vertices.size, value);
        return vertices;
    }

    public static FloatArray subX(FloatArray vertices, float value) {
        GeometryUtils.subX(vertices.items, 0, vertices.size, value);
        return vertices;
    }

    public static FloatArray addY(FloatArray vertices, float value) {
        GeometryUtils.addY(vertices.items, 0, vertices.size, value);
        return vertices;
    }

    public static FloatArray subY(FloatArray vertices, float value) {
        GeometryUtils.subY(vertices.items, 0, vertices.size, value);
        return vertices;
    }

    public static FloatArray mul(FloatArray vertices, float factorX, float factorY) {
        GeometryUtils.mul(vertices.items, 0, vertices.size, factorX, factorY);
        return vertices;
    }

    public static FloatArray mulX(FloatArray vertices, float factor) {
        GeometryUtils.mulX(vertices.items, 0, vertices.size, factor);
        return vertices;
    }

    public static FloatArray mulY(FloatArray vertices, float factor) {
        GeometryUtils.mulY(vertices.items, 0, vertices.size, factor);
        return vertices;
    }

    public static FloatArray div(FloatArray vertices, float divisorX, float divisorY) {
        GeometryUtils.div(vertices.items, 0, vertices.size, divisorX, divisorY);
        return vertices;
    }

    public static FloatArray divX(FloatArray vertices, float divisor) {
        GeometryUtils.divX(vertices.items, 0, vertices.size, divisor);
        return vertices;
    }

    public static FloatArray divY(FloatArray vertices, float divisor) {
        GeometryUtils.divY(vertices.items, 0, vertices.size, divisor);
        return vertices;
    }

    public static Vector2 size(Array<Vector2> vertices, Vector2 output) {
        return output.set(GeometryUtils.width(vertices), GeometryUtils.height(vertices));
    }

    public static Vector2 size(Array<Vector2> vertices) {
        return GeometryUtils.size(vertices, vec2_0);
    }

    public static float width(Array<Vector2> vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterX(vertices));
    }

    public static float height(Array<Vector2> vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterY(vertices));
    }

    public static float width(FloatArray vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterX(vertices));
    }

    public static float height(FloatArray vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterY(vertices));
    }

    public static float depth(FloatArray vertices) {
        return MathUtils.amplitude2(GeometryUtils.filterZ(vertices));
    }

    public static FloatArray filterX(Array<Vector2> vertices, FloatArray output) {
        if (output == null) {
            output = new FloatArray(vertices.size);
        }
        output.clear();
        output.ensureCapacity(vertices.size);
        for (int i = 0; i < vertices.size; ++i) {
            output.add(vertices.get((int)i).x);
        }
        return output;
    }

    public static FloatArray filterX(Array<Vector2> vertices) {
        return GeometryUtils.filterX(vertices, tmpFloatArray);
    }

    public static FloatArray filterX(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, -1, 2, output);
    }

    public static FloatArray filterX(FloatArray vertices) {
        return GeometryUtils.filterX(vertices, tmpFloatArray);
    }

    public static FloatArray filterX3D(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, -2, 3, output);
    }

    public static FloatArray filterX3D(FloatArray vertices) {
        return GeometryUtils.filterX3D(vertices, tmpFloatArray);
    }

    public static FloatArray filterY(Array<Vector2> vertices, FloatArray output) {
        if (output == null) {
            output = new FloatArray(vertices.size);
        }
        output.clear();
        output.ensureCapacity(vertices.size);
        for (int i = 0; i < vertices.size; ++i) {
            output.add(vertices.get((int)i).y);
        }
        return output;
    }

    public static FloatArray filterY(Array<Vector2> vertices) {
        return GeometryUtils.filterY(vertices, tmpFloatArray);
    }

    public static FloatArray filterY(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, 2, output);
    }

    public static FloatArray filterY(FloatArray vertices) {
        return GeometryUtils.filterY(vertices, tmpFloatArray);
    }

    public static FloatArray filterY3D(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, -4, 3, output);
    }

    public static FloatArray filterY3D(FloatArray vertices) {
        return GeometryUtils.filterY3D(vertices, tmpFloatArray);
    }

    public static FloatArray filterZ(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, 3, output);
    }

    public static FloatArray filterZ(FloatArray vertices) {
        return GeometryUtils.filterZ(vertices, tmpFloatArray);
    }

    public static FloatArray filterW(FloatArray vertices, FloatArray output) {
        return ArrayUtils.select(vertices, 4, output);
    }

    public static FloatArray filterW(FloatArray vertices) {
        return GeometryUtils.filterW(vertices, tmpFloatArray);
    }

    public static float minX(Array<Vector2> vertices) {
        return MathUtils.min(GeometryUtils.filterX(vertices));
    }

    public static float minY(Array<Vector2> vertices) {
        return MathUtils.min(GeometryUtils.filterY(vertices));
    }

    public static float maxX(Array<Vector2> vertices) {
        return MathUtils.max(GeometryUtils.filterX(vertices));
    }

    public static float maxY(Array<Vector2> vertices) {
        return MathUtils.max(GeometryUtils.filterY(vertices));
    }

    public static float minX(FloatArray vertices) {
        return MathUtils.min(GeometryUtils.filterX(vertices));
    }

    public static float minY(FloatArray vertices) {
        return MathUtils.min(GeometryUtils.filterY(vertices));
    }

    public static float maxX(FloatArray vertices) {
        return MathUtils.max(GeometryUtils.filterX(vertices));
    }

    public static float maxY(FloatArray vertices) {
        return MathUtils.max(GeometryUtils.filterY(vertices));
    }

    public static FloatArray scale(FloatArray vertices, float minX, float minY, float maxX, float maxY) {
        GeometryUtils.scale(vertices.items, 0, vertices.size, minX, minY, maxX, maxY);
        return vertices;
    }

    public static FloatArray scale(FloatArray vertices, Vector2 min, Vector2 max) {
        return GeometryUtils.scale(vertices, min.x, min.y, max.x, max.y);
    }

    public static FloatArray reverse(FloatArray vertices) {
        GeometryUtils.reverse(vertices.items, 0, vertices.size);
        return vertices;
    }

    public static FloatArray reverse3D(FloatArray vertices) {
        GeometryUtils.reverse3D(vertices.items, 0, vertices.size);
        return vertices;
    }

    public static Vector2 rotate(Vector2 point, Vector2 origin, float radians) {
        if (point.equals(origin)) {
            return point;
        }
        return point.sub(origin).rotateRad(radians).add(origin);
    }

    public static void rotateLine(Vector2 a, Vector2 b, float radians) {
        GeometryUtils.rotate(a, vec2_0.set(a).add(b).scl(0.5f), radians);
        GeometryUtils.rotate(b, vec2_0, radians);
    }

    public static FloatArray rotate(float x, float y, float width, float height, float radians, FloatArray output) {
        output.clear();
        output.ensureCapacity(8);
        GeometryUtils.rotate(x, y, width, height, radians, output.items, 0);
        return output;
    }

    public static FloatArray rotate(float x, float y, float width, float height, float radians) {
        return GeometryUtils.rotate(x, y, width, height, radians, tmpFloatArray);
    }

    public static FloatArray rotate(Rectangle rectangle, float radians, FloatArray output) {
        return GeometryUtils.rotate(rectangle.x, rectangle.y, rectangle.width, rectangle.height, radians, output);
    }

    public static FloatArray rotate(Rectangle rectangle, float radians) {
        return GeometryUtils.rotate(rectangle, radians, tmpFloatArray);
    }

    public static FloatArray toFloatArray(Array<Vector2> vector2s, FloatArray output) {
        if (output == null) {
            output = new FloatArray(vector2s.size * 2);
        }
        output.clear();
        output.ensureCapacity(vector2s.size * 2);
        int vi = -1;
        for (int i = 0; i < vector2s.size * 2; ++i) {
            if (i % 2 == 0) {
                output.add(vector2s.get((int)(++vi)).x);
                continue;
            }
            output.add(vector2s.get((int)vi).y);
        }
        return output;
    }

    public static FloatArray toFloatArray(Array<Vector2> vector2s) {
        return GeometryUtils.toFloatArray(vector2s, tmpFloatArray);
    }

    public static Array<Vector2> toVector2Array(FloatArray floats, Array<Vector2> output) {
        if (floats.size % 2 != 0) {
            throw new IllegalArgumentException("the float array's length is not dividable by two, so it won't make up a Vector2 array: " + floats.size);
        }
        if (output == null) {
            output = new Array(floats.size / 2);
        }
        output.clear();
        int fi = -1;
        for (int i = 0; i < floats.size / 2; ++i) {
            output.add(new Vector2(floats.get(++fi), floats.get(++fi)));
        }
        return output;
    }

    public static Array<Vector2> toVector2Array(FloatArray floats) {
        return GeometryUtils.toVector2Array(floats, tmpVector2Array);
    }

    public static Polygon[] toPolygonArray(Array<Vector2> vertices, int vertexCount) {
        IntArray vertexCounts = Pools.obtain(IntArray.class);
        vertexCounts.clear();
        vertexCounts.ensureCapacity(vertices.size / vertexCount);
        for (int i = 0; i < vertices.size / vertexCount; ++i) {
            vertexCounts.add(vertexCount);
        }
        Polygon[] polygons = GeometryUtils.toPolygonArray(vertices, vertexCounts);
        vertexCounts.clear();
        Pools.free(vertexCounts);
        return polygons;
    }

    public static Polygon[] toPolygonArray(Array<Vector2> vertices, IntArray vertexCounts) {
        Polygon[] polygons = new Polygon[vertexCounts.size];
        int vertice = -1;
        for (int i = 0; i < polygons.length; ++i) {
            tmpVector2Array.clear();
            tmpVector2Array.ensureCapacity(vertexCounts.get(i));
            for (int i2 = 0; i2 < vertexCounts.get(i); ++i2) {
                tmpVector2Array.add(vertices.get(++vertice));
            }
            polygons[i] = new Polygon(GeometryUtils.toFloatArray(tmpVector2Array).toArray());
        }
        return polygons;
    }

    public static Polygon[] toPolygonArray(float[][] polygons) {
        Polygon[] polys = new Polygon[polygons.length];
        for (int i = 0; i < polys.length; ++i) {
            polys[i] = new Polygon(polygons[i]);
        }
        return polys;
    }

    public static boolean areVerticesClockwise(Polygon polygon) {
        return polygon.area() < 0.0f;
    }

    public static boolean areVerticesClockwise(FloatArray vertices) {
        return GeometryUtils.areVerticesClockwise(vertices.items, 0, vertices.size);
    }

    public static boolean areVerticesClockwise(Array<Vector2> vertices) {
        return vertices.size <= 2 || GeometryUtils.areVerticesClockwise(GeometryUtils.toFloatArray(vertices));
    }

    public static float polygonArea(FloatArray vertices) {
        return GeometryUtils.polygonArea(vertices.items, 0, vertices.size);
    }

    public static void arrangeConvexPolygon(FloatArray vertices, boolean clockwise) {
        GeometryUtils.arrangeConvexPolygon(vertices.items, 0, vertices.size, clockwise);
    }

    public static FloatArray invertAxes(FloatArray vertices, boolean x, boolean y) {
        GeometryUtils.invertAxes(vertices.items, 0, vertices.size, x, y);
        return vertices;
    }

    public static FloatArray toYDown(FloatArray vertices) {
        GeometryUtils.toYDown(vertices.items, 0, vertices.size);
        return vertices;
    }

    public static FloatArray toYUp(FloatArray vertices) {
        GeometryUtils.toYUp(vertices.items, 0, vertices.size);
        return vertices;
    }

    public static Rectangle setToAABB(Rectangle aabb, float[] vertices, int offset, int length) {
        return aabb.set(GeometryUtils.minX(vertices, offset, length), GeometryUtils.minY(vertices, offset, length), GeometryUtils.width(vertices, offset, length), GeometryUtils.height(vertices, offset, length));
    }

    public static Rectangle setToAABB(Rectangle aabb, float[] vertices) {
        return GeometryUtils.setToAABB(aabb, vertices, 0, vertices.length);
    }

    public static Rectangle setToAABB(Rectangle aabb, FloatArray vertices) {
        return GeometryUtils.setToAABB(aabb, vertices.items, 0, vertices.size);
    }

    public static Rectangle setToAABB(Rectangle aabb, Array<Vector2> vertices) {
        return aabb.set(GeometryUtils.minX(vertices), GeometryUtils.minY(vertices), GeometryUtils.width(vertices), GeometryUtils.height(vertices));
    }

    public static boolean isConvex(FloatArray vertices) {
        return GeometryUtils.isConvex(vertices.items, 0, vertices.size);
    }

    public static boolean isConvex(Polygon polygon) {
        return GeometryUtils.isConvex(polygon.getVertices());
    }

    public static boolean isConvex(Array<Vector2> vertices) {
        return GeometryUtils.isConvex(GeometryUtils.toFloatArray(vertices));
    }

    public static float[][] triangulate(float[] polygon) {
        return GeometryUtils.triangulate(polygon, 0, polygon.length);
    }

    public static float[][] triangulate(float[] polygon, int offset, int length) {
        EarClippingTriangulator triangulator = Pools.obtain(EarClippingTriangulator.class);
        ShortArray indices = triangulator.computeTriangles(polygon, offset, length);
        Pools.free(triangulator);
        float[][] triangles = new float[indices.size / 3][];
        int ti = 0;
        for (int i = 0; i < indices.size; i += 3) {
            int p1 = indices.get(i) * 2;
            int p2 = indices.get(i + 1) * 2;
            int p3 = indices.get(i + 2) * 2;
            triangles[ti] = new float[]{polygon[p1], polygon[p1 + 1], polygon[p2], polygon[p2 + 1], polygon[p3], polygon[p3 + 1]};
            ++ti;
        }
        return triangles;
    }

    public static float[][] decompose(float[] concave) {
        return GeometryUtils.decompose(concave, 0, concave.length);
    }

    public static float[][] decompose(float[] concave, int offset, int length) {
        ArrayUtils.checkRegion(concave, offset, length);
        tmpFloatArray.clear();
        tmpFloatArray.addAll(concave, offset, length);
        Array<Array<Vector2>> convexPolys = BayazitDecomposer.convexPartition(GeometryUtils.toVector2Array(tmpFloatArray));
        float[][] convexPolygons = new float[convexPolys.size][];
        for (int i = 0; i < convexPolygons.length; ++i) {
            convexPolygons[i] = GeometryUtils.toFloatArray(convexPolys.get(i)).toArray();
        }
        return convexPolygons;
    }

    public static Vector2 keepWithin(Vector2 position, float width, float height, float x2, float y2, float width2, float height2) {
        if (width2 < width) {
            position.x = x2 + width2 / 2.0f - width / 2.0f;
        } else if (position.x < x2) {
            position.x = x2;
        } else if (position.x + width > x2 + width2) {
            position.x = x2 + width2 - width;
        }
        if (height2 < height) {
            position.y = y2 + height2 / 2.0f - height / 2.0f;
        } else if (position.y < y2) {
            position.y = y2;
        } else if (position.y + height > y2 + height2) {
            position.y = y2 + height2 - height;
        }
        return position;
    }

    public static Vector2 keepWithin(float x, float y, float width, float height, float rectX, float rectY, float rectWidth, float rectHeight) {
        return GeometryUtils.keepWithin(vec2_0.set(x, y), width, height, rectX, rectY, rectWidth, rectHeight);
    }

    public static Rectangle keepWithin(Rectangle rect, Rectangle other) {
        return rect.setPosition(GeometryUtils.keepWithin(rect.x, rect.y, rect.width, rect.height, other.x, other.y, other.width, other.height));
    }

    public static void keepWithin(OrthographicCamera camera, float x, float y, float width, float height) {
        vec2_0.set(GeometryUtils.keepWithin(camera.position.x - camera.viewportWidth / 2.0f * camera.zoom, camera.position.y - camera.viewportHeight / 2.0f * camera.zoom, camera.viewportWidth * camera.zoom, camera.viewportHeight * camera.zoom, x, y, width, height));
        camera.position.x = GeometryUtils.vec2_0.x + camera.viewportWidth / 2.0f * camera.zoom;
        camera.position.y = GeometryUtils.vec2_0.y + camera.viewportHeight / 2.0f * camera.zoom;
    }

    public static int intersectSegmentConvexPolygon(float x1, float y1, float x2, float y2, float[] polygon, Vector2 intersection1, Vector2 intersection2) {
        return GeometryUtils.intersectSegmentConvexPolygon(x1, y1, x2, y2, polygon, 0, polygon.length, intersection1, intersection2);
    }

    public static int intersectSegmentConvexPolygon(float x1, float y1, float x2, float y2, float[] polygon, int offset, int length, Vector2 intersection1, Vector2 intersection2) {
        FloatArray intersections = Pools.obtain(FloatArray.class);
        GeometryUtils.intersectSegments(x1, y1, x2, y2, polygon, offset, length, true, intersections);
        assert (intersections.size % 2 == 0);
        int count = intersections.size / 2;
        if (count >= 1) {
            if (intersection1 != null) {
                intersection1.set(intersections.get(0), intersections.get(1));
            }
            if (count >= 2 && intersection2 != null) {
                intersection2.set(intersections.get(2), intersections.get(3));
            }
        }
        intersections.clear();
        Pools.free(intersections);
        if (count > 3) {
            throw new IllegalArgumentException("More intersections with a convex polygon found than possible: " + count + ". Is your polygon concave? " + ArrayUtils.toString(polygon, offset, length) + " segment: [" + x1 + ", " + y1 + "; " + x2 + ", " + y2 + "]");
        }
        return count == 3 ? -1 : count;
    }

    public static int intersectSegmentConvexPolygon(Vector2 a, Vector2 b, FloatArray polygon, Vector2 intersection1, Vector2 intersection2) {
        return GeometryUtils.intersectSegmentConvexPolygon(a.x, a.y, b.x, b.y, polygon.items, 0, polygon.size, intersection1, intersection2);
    }

    public static boolean intersectSegments(Vector2 a, Vector2 b, FloatArray segments, boolean polygon, Array<Vector2> intersections) {
        FloatArray floatIntersections = Pools.obtain(FloatArray.class);
        intersections.clear();
        if (!GeometryUtils.intersectSegments(a.x, a.y, b.x, b.y, segments, polygon, floatIntersections)) {
            floatIntersections.clear();
            Pools.free(floatIntersections);
            return false;
        }
        intersections.ensureCapacity(floatIntersections.size / 2);
        for (int i = 1; i < floatIntersections.size; i += 2) {
            intersections.add(new Vector2(floatIntersections.get(i - 1), floatIntersections.get(i)));
        }
        floatIntersections.clear();
        Pools.free(floatIntersections);
        return true;
    }

    public static boolean intersectSegments(float x1, float y1, float x2, float y2, FloatArray segments, boolean polygon, FloatArray intersections) {
        return GeometryUtils.intersectSegments(x1, y1, x2, y2, segments.items, 0, segments.size, polygon, intersections);
    }

    public static boolean intersectSegments(float x1, float y1, float x2, float y2, float[] segments, int offset, int length, boolean polygon, FloatArray intersections) {
        ArrayUtils.checkRegion(segments, offset, length);
        if (polygon && length < 6) {
            throw new IllegalArgumentException("A polygon consists of at least 3 points. length: " + length);
        }
        if (length < 4) {
            throw new IllegalArgumentException("segments does not contain enough vertices to represent at least one segment: " + length);
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("malformed segments, length is odd: " + length);
        }
        intersections.clear();
        boolean intersects = false;
        int n = offset + length - (polygon ? 0 : 2);
        for (int i = offset; i < n; i += 2) {
            float y4;
            float x3 = segments[i];
            float y3 = segments[i + 1];
            float x4 = segments[ArrayUtils.repeat(offset, length, i + 2)];
            if (!Intersector.intersectSegments(x1, y1, x2, y2, x3, y3, x4, y4 = segments[ArrayUtils.repeat(offset, length, i + 3)], vec2_0)) continue;
            intersects = true;
            intersections.add(GeometryUtils.vec2_0.x);
            intersections.add(GeometryUtils.vec2_0.y);
        }
        return intersects;
    }

    public static void clip(float[] polygon, float[] clip, FloatArray clipped) {
        GeometryUtils.clip(polygon, 0, polygon.length, clip, 0, clip.length, clipped);
    }

    public static void clip(float[] polygon, int offset, int length, float[] clip, int clipOffset, int clipLength, FloatArray clipped) {
        ArrayUtils.checkRegion(polygon, offset, length);
        ArrayUtils.checkRegion(clip, clipOffset, clipLength);
        clipped.clear();
        int inside = GeometryUtils.areVerticesClockwise(clip, clipOffset, clipLength) ? -1 : 1;
        FloatArray output = Pools.obtain(FloatArray.class);
        FloatArray input = Pools.obtain(FloatArray.class);
        output.clear();
        output.addAll(polygon);
        for (int i = clipOffset; i < clipOffset + clipLength; i += 2) {
            float clipEdgeX1 = clip[ArrayUtils.repeat(clipOffset, clipLength, i)];
            float clipEdgeY1 = clip[ArrayUtils.repeat(clipOffset, clipLength, i + 1)];
            float clipEdgeX2 = clip[ArrayUtils.repeat(clipOffset, clipLength, i + 2)];
            float clipEdgeY2 = clip[ArrayUtils.repeat(clipOffset, clipLength, i + 3)];
            input.clear();
            input.addAll(output);
            output.clear();
            float sX = input.get(input.size - 2);
            float sY = input.get(input.size - 1);
            for (int ii = 0; ii < input.size; ii += 2) {
                float eY;
                float eX = input.get(ii);
                if (inside == Intersector.pointLineSide(clipEdgeX1, clipEdgeY1, clipEdgeX2, clipEdgeY2, eX, eY = input.get(ii + 1))) {
                    if (inside != Intersector.pointLineSide(clipEdgeX1, clipEdgeY1, clipEdgeX2, clipEdgeY2, sX, sY)) {
                        Intersector.intersectLines(sX, sY, eX, eY, clipEdgeX1, clipEdgeY1, clipEdgeX2, clipEdgeY2, vec2_0);
                        output.ensureCapacity(2);
                        output.add(GeometryUtils.vec2_0.x);
                        output.add(GeometryUtils.vec2_0.y);
                    }
                    output.ensureCapacity(2);
                    output.add(eX);
                    output.add(eY);
                } else if (inside == Intersector.pointLineSide(clipEdgeX1, clipEdgeY1, clipEdgeX2, clipEdgeY2, sX, sY)) {
                    Intersector.intersectLines(sX, sY, eX, eY, clipEdgeX1, clipEdgeY1, clipEdgeX2, clipEdgeY2, vec2_0);
                    output.ensureCapacity(2);
                    output.add(GeometryUtils.vec2_0.x);
                    output.add(GeometryUtils.vec2_0.y);
                }
                sX = eX;
                sY = eY;
            }
            if (output.size == 0) break;
        }
        clipped.addAll(output);
        output.clear();
        input.clear();
        Pools.free(output);
        Pools.free(input);
    }

    public static <T extends Shape2D> T reset(T shape) {
        if (shape instanceof Polygon) {
            return (T)GeometryUtils.reset((Polygon)shape);
        }
        if (shape instanceof Polyline) {
            return (T)GeometryUtils.reset((Polyline)shape);
        }
        if (shape instanceof Rectangle) {
            return (T)GeometryUtils.reset((Rectangle)shape);
        }
        if (shape instanceof Circle) {
            return (T)GeometryUtils.reset((Circle)shape);
        }
        if (shape instanceof Ellipse) {
            return (T)GeometryUtils.reset((Ellipse)shape);
        }
        return shape;
    }

    public static Polygon reset(Polygon polygon) {
        polygon.setPosition(0.0f, 0.0f);
        polygon.setRotation(0.0f);
        polygon.setOrigin(0.0f, 0.0f);
        polygon.setScale(1.0f, 1.0f);
        float[] vertices = polygon.getVertices();
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = 0.0f;
        }
        return polygon;
    }

    public static Polyline reset(Polyline polyline) {
        polyline.setPosition(0.0f, 0.0f);
        polyline.setRotation(0.0f);
        polyline.setOrigin(0.0f, 0.0f);
        polyline.setScale(1.0f, 1.0f);
        float[] vertices = polyline.getVertices();
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = 0.0f;
        }
        return polyline;
    }

    public static Rectangle reset(Rectangle rectangle) {
        return rectangle.set(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Circle reset(Circle circle) {
        circle.set(0.0f, 0.0f, 0.0f);
        return circle;
    }

    public static Ellipse reset(Ellipse ellipse) {
        ellipse.set(0.0f, 0.0f, 0.0f, 0.0f);
        return ellipse;
    }
}

