/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ArraySelection;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Pools;
import java.io.File;
import net.dermetfan.gdx.scenes.scene2d.ui.FileChooser;
import net.dermetfan.gdx.scenes.scene2d.ui.UIUtils;

public class ListFileChooser
extends FileChooser {
    private Style style;
    private Files.FileType fileType = Files.FileType.Absolute;
    private final Array<FileHandle> fileHistory = new Array();
    private FileHandle directory;
    private TextField pathField;
    private List<String> contents;
    private ScrollPane contentsPane;
    private Button backButton;
    private Button parentButton;
    private Button chooseButton;
    private Button openButton;
    private Button cancelButton;
    public final TextField.TextFieldListener pathFieldListener = new TextField.TextFieldListener(){

        @Override
        public void keyTyped(TextField textField, char key) {
            if (key == '\r' || key == '\n') {
                FileHandle loc = Gdx.files.getFileHandle(textField.getText(), ListFileChooser.this.fileType);
                if (ListFileChooser.this.isNewFilesChoosable() || loc.exists()) {
                    if (loc.isDirectory()) {
                        ListFileChooser.this.setDirectory(loc);
                    } else {
                        ListFileChooser.this.getListener().choose(loc);
                    }
                    if (ListFileChooser.this.getStage() != null) {
                        ListFileChooser.this.getStage().setKeyboardFocus(ListFileChooser.this);
                    }
                }
            }
        }
    };
    public final ClickListener chooseButtonListener = new ClickListener(){

        @Override
        public void clicked(InputEvent event, float x, float y) {
            ArraySelection selection = ListFileChooser.this.contents.getSelection();
            if (!selection.getMultiple()) {
                FileHandle selected = ListFileChooser.this.currentlySelected();
                if (!ListFileChooser.this.isDirectoriesChoosable() && selected.isDirectory()) {
                    ListFileChooser.this.setDirectory(selected);
                } else {
                    ListFileChooser.this.getListener().choose(selected);
                }
            } else {
                Array files = Pools.obtain(Array.class);
                files.clear();
                for (String fileName : selection) {
                    files.add(ListFileChooser.this.directory.child(fileName));
                }
                ListFileChooser.this.getListener().choose(files);
                Pools.free(files);
            }
        }
    };
    public final ClickListener openButtonListener = new ClickListener(){

        @Override
        public void clicked(InputEvent event, float x, float y) {
            FileHandle child = ListFileChooser.this.currentlySelected();
            if (child.isDirectory()) {
                ListFileChooser.this.setDirectory(child);
            }
        }
    };
    public final ClickListener cancelButtonListener = new ClickListener(){

        @Override
        public void clicked(InputEvent event, float x, float y) {
            ListFileChooser.this.getListener().cancel();
        }
    };
    public final ClickListener backButtonListener = new ClickListener(){

        @Override
        public void clicked(InputEvent event, float x, float y) {
            if (((ListFileChooser)ListFileChooser.this).fileHistory.size > 1) {
                ListFileChooser.this.fileHistory.removeIndex(((ListFileChooser)ListFileChooser.this).fileHistory.size - 1);
                ListFileChooser.this.setDirectory(ListFileChooser.this.directory = (FileHandle)ListFileChooser.this.fileHistory.peek(), false);
            }
        }
    };
    public final ClickListener parentButtonListener = new ClickListener(){

        @Override
        public void clicked(InputEvent event, float x, float y) {
            ListFileChooser.this.setDirectory(ListFileChooser.this.directory.parent());
        }
    };
    public final ChangeListener contentsListener = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            ListFileChooser.this.openButton.setDisabled(!ListFileChooser.this.currentlySelected().isDirectory());
            ListFileChooser.this.chooseButton.setDisabled(ListFileChooser.this.isDirectoriesChoosable());
        }
    };
    public final InputListener keyControlsListener = new InputListener(){

        @Override
        public boolean keyTyped(InputEvent event, char c) {
            int direction;
            if (event.isHandled()) {
                return true;
            }
            if (!(ListFileChooser.this.getStage() != null && ListFileChooser.this.getStage().getKeyboardFocus() == ListFileChooser.this.pathField || c != '\r' && c != '\n')) {
                if (ListFileChooser.this.currentlySelected().isDirectory()) {
                    ListFileChooser.this.openButtonListener.clicked(null, 0.0f, 0.0f);
                } else {
                    ListFileChooser.this.chooseButtonListener.clicked(null, 0.0f, 0.0f);
                }
                return true;
            }
            int keyCode = event.getKeyCode();
            if (keyCode == 67) {
                ListFileChooser.this.backButtonListener.clicked(null, 0.0f, 0.0f);
                return true;
            }
            if (keyCode == 21) {
                ListFileChooser.this.parentButtonListener.clicked(null, 0.0f, 0.0f);
                return true;
            }
            if (keyCode == 19) {
                direction = -1;
            } else if (keyCode == 20) {
                direction = 1;
            } else {
                return false;
            }
            int newIndex = ListFileChooser.this.contents.getSelectedIndex() + direction;
            newIndex = MathUtils.clamp(newIndex, 0, ((ListFileChooser)ListFileChooser.this).contents.getItems().size - 1);
            ListFileChooser.this.contents.setSelectedIndex(newIndex);
            return true;
        }
    };

    public ListFileChooser(Skin skin, FileChooser.Listener listener) {
        this(skin.get(Style.class), listener);
        this.setSkin(skin);
    }

    public ListFileChooser(Skin skin, String styleName, FileChooser.Listener listener) {
        this(skin.get(styleName, Style.class), listener);
        this.setSkin(skin);
    }

    public ListFileChooser(Style style, FileChooser.Listener listener) {
        super(listener);
        this.style = style;
        this.buildWidgets();
        this.setDirectory(Gdx.files.absolute(Gdx.files.getExternalStoragePath()));
        this.build();
        this.refresh();
    }

    public void setFileType(Files.FileType fileType) {
        this.fileType = fileType;
        this.fileHistory.clear();
        this.setDirectory(Gdx.files.getFileHandle("", fileType));
    }

    protected void buildWidgets() {
        this.addListener(this.keyControlsListener);
        this.pathField = new TextField("", this.style.pathFieldStyle);
        this.pathField.setTextFieldListener(this.pathFieldListener);
        this.contents = new List(this.style.contentsStyle);
        this.contents.addListener(this.contentsListener);
        this.chooseButton = UIUtils.newButton(this.style.chooseButtonStyle, "select");
        this.chooseButton.addListener(this.chooseButtonListener);
        this.openButton = UIUtils.newButton(this.style.openButtonStyle, "open");
        this.openButton.addListener(this.openButtonListener);
        this.cancelButton = UIUtils.newButton(this.style.cancelButtonStyle, "cancel");
        this.cancelButton.addListener(this.cancelButtonListener);
        this.backButton = UIUtils.newButton(this.style.backButtonStyle, "back");
        this.backButton.addListener(this.backButtonListener);
        this.parentButton = UIUtils.newButton(this.style.parentButtonStyle, "up");
        this.parentButton.addListener(this.parentButtonListener);
        this.contentsPane = this.style.contentsPaneStyle == null ? new ScrollPane((Actor)this.contents) : new ScrollPane(this.contents, this.style.contentsPaneStyle);
        this.setBackground(this.style.background);
    }

    @Override
    protected void build() {
        this.clearChildren();
        Style style = this.getStyle();
        this.add(this.backButton).fill().space(style.space);
        this.add(this.pathField).fill().space(style.space);
        this.add(this.parentButton).fill().space(style.space).row();
        this.add(this.contentsPane).colspan(3).expand().fill().space(style.space).row();
        if (this.isDirectoriesChoosable()) {
            this.add(this.openButton).fill().space(style.space);
        }
        this.add(this.chooseButton).fill().colspan(this.isDirectoriesChoosable() ? 1 : 2).space(style.space);
        this.add(this.cancelButton).fill().space(style.space);
    }

    public void refresh() {
        this.scan(this.directory);
    }

    protected void scan(FileHandle dir) {
        try {
            FileHandle[] files = dir.list(this.handlingFileFilter);
            String[] names = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].name();
                if (files[i].isDirectory()) {
                    name = name + File.separator;
                }
                names[i] = name;
            }
            this.contents.setItems((String[])names);
        }
        catch (GdxRuntimeException ignore) {
            Gdx.app.error("ListFileChooser", " cannot read " + dir);
        }
    }

    public FileHandle currentlySelected() {
        String selected = this.contents.getSelected();
        return selected == null ? this.directory : this.directory.child(selected);
    }

    public void setDirectory(FileHandle dir) {
        this.setDirectory(dir, true);
    }

    public void setDirectory(FileHandle dir, boolean addToHistory) {
        FileHandle loc;
        FileHandle fileHandle = loc = dir.isDirectory() ? dir : dir.parent();
        if (addToHistory) {
            this.fileHistory.add(loc);
        }
        this.directory = loc;
        this.scan(this.directory);
        this.pathField.setText(loc.path());
        this.pathField.setCursorPosition(this.pathField.getText().length());
    }

    public Button getBackButton() {
        return this.backButton;
    }

    public void setBackButton(Button backButton) {
        this.backButton.removeListener(this.backButtonListener);
        backButton.addListener(this.backButtonListener);
        this.backButton = backButton;
        this.getCell(this.backButton).setActor(this.backButton);
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(Button cancelButton) {
        this.cancelButton.removeListener(this.cancelButtonListener);
        cancelButton.addListener(this.cancelButtonListener);
        this.cancelButton = cancelButton;
        this.getCell(this.cancelButton).setActor(this.cancelButton);
    }

    public Button getChooseButton() {
        return this.chooseButton;
    }

    public void setChooseButton(Button chooseButton) {
        this.chooseButton.removeListener(this.chooseButtonListener);
        chooseButton.addListener(this.chooseButtonListener);
        this.chooseButton = chooseButton;
        this.getCell(this.chooseButton).setActor(this.chooseButton);
    }

    public List<String> getContents() {
        return this.contents;
    }

    public void setContents(List<String> contents) {
        this.contents.removeListener(this.contentsListener);
        contents.addListener(this.contentsListener);
        this.contentsPane.setWidget(contents);
    }

    public ScrollPane getContentsPane() {
        return this.contentsPane;
    }

    public void setContentsPane(ScrollPane contentsPane) {
        contentsPane.setWidget(this.contents);
        this.contentsPane = contentsPane;
        this.getCell(this.contentsPane).setActor(this.contentsPane);
    }

    public FileHandle getDirectory() {
        return this.directory;
    }

    public Array<FileHandle> getFileHistory() {
        return this.fileHistory;
    }

    public void setFileHistory(Array<FileHandle> fileHistory) {
        this.fileHistory.clear();
        this.fileHistory.addAll(fileHistory);
    }

    public Button getOpenButton() {
        return this.openButton;
    }

    public void setOpenButton(Button openButton) {
        this.openButton.removeListener(this.openButtonListener);
        openButton.addListener(this.openButtonListener);
        this.openButton = openButton;
        this.getCell(this.openButton).setActor(this.openButton);
    }

    public Button getParentButton() {
        return this.parentButton;
    }

    public void setParentButton(Button parentButton) {
        this.parentButton.removeListener(this.parentButtonListener);
        parentButton.addListener(this.parentButtonListener);
        this.parentButton = parentButton;
        this.getCell(this.parentButton).setActor(this.parentButton);
    }

    public TextField getPathField() {
        return this.pathField;
    }

    public void setPathField(TextField pathField) {
        this.pathField.setTextFieldListener(null);
        pathField.setTextFieldListener(this.pathFieldListener);
        this.pathField = pathField;
        this.getCell(this.pathField).setActor(this.pathField);
    }

    @Override
    public void setDirectoriesChoosable(boolean directoriesChoosable) {
        if (this.isDirectoriesChoosable() != directoriesChoosable) {
            super.setDirectoriesChoosable(directoriesChoosable);
            this.build();
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        this.setBackground(style.background);
        this.backButton.setStyle(style.backButtonStyle);
        this.cancelButton.setStyle(style.cancelButtonStyle);
        this.chooseButton.setStyle(style.chooseButtonStyle);
        this.contents.setStyle(style.contentsStyle);
        this.contentsPane.setStyle(style.contentsPaneStyle);
        this.openButton.setStyle(style.openButtonStyle);
        this.parentButton.setStyle(style.parentButtonStyle);
        this.pathField.setStyle(style.pathFieldStyle);
    }

    public static class Style
    implements Json.Serializable {
        public TextField.TextFieldStyle pathFieldStyle;
        public List.ListStyle contentsStyle;
        public Button.ButtonStyle chooseButtonStyle;
        public Button.ButtonStyle openButtonStyle;
        public Button.ButtonStyle cancelButtonStyle;
        public Button.ButtonStyle backButtonStyle;
        public Button.ButtonStyle parentButtonStyle;
        public float space;
        public ScrollPane.ScrollPaneStyle contentsPaneStyle;
        public Drawable background;

        public Style() {
        }

        public Style(Style style) {
            this.set(style);
        }

        public Style(TextField.TextFieldStyle textFieldStyle, List.ListStyle listStyle, Button.ButtonStyle buttonStyles, Drawable background) {
            this(textFieldStyle, listStyle, buttonStyles, buttonStyles, buttonStyles, buttonStyles, buttonStyles, background);
        }

        public Style(TextField.TextFieldStyle pathFieldStyle, List.ListStyle contentsStyle, Button.ButtonStyle chooseButtonStyle, Button.ButtonStyle openButtonStyle, Button.ButtonStyle cancelButtonStyle, Button.ButtonStyle backButtonStyle, Button.ButtonStyle parentButtonStyle, Drawable background) {
            this.pathFieldStyle = pathFieldStyle;
            this.contentsStyle = contentsStyle;
            this.chooseButtonStyle = chooseButtonStyle;
            this.openButtonStyle = openButtonStyle;
            this.cancelButtonStyle = cancelButtonStyle;
            this.backButtonStyle = backButtonStyle;
            this.parentButtonStyle = parentButtonStyle;
            this.background = background;
        }

        public void set(Style style) {
            this.pathFieldStyle = style.pathFieldStyle;
            this.contentsStyle = style.contentsStyle;
            this.chooseButtonStyle = style.chooseButtonStyle;
            this.openButtonStyle = style.openButtonStyle;
            this.cancelButtonStyle = style.cancelButtonStyle;
            this.backButtonStyle = style.backButtonStyle;
            this.parentButtonStyle = style.parentButtonStyle;
            this.contentsPaneStyle = style.contentsPaneStyle;
            this.background = style.background;
            this.space = style.space;
        }

        public void setButtonStyles(Button.ButtonStyle style) {
            this.backButtonStyle = this.parentButtonStyle = style;
            this.cancelButtonStyle = this.parentButtonStyle;
            this.openButtonStyle = this.parentButtonStyle;
            this.chooseButtonStyle = this.parentButtonStyle;
        }

        @Override
        public void write(Json json) {
            json.writeObjectStart("");
            json.writeFields(this);
            json.writeObjectEnd();
        }

        @Override
        public void read(Json json, JsonValue jsonData) {
            Button.ButtonStyle tmpBS = UIUtils.readButtonStyle("buttonStyles", json, jsonData);
            this.setButtonStyles(tmpBS);
            tmpBS = UIUtils.readButtonStyle("backButtonStyle", json, jsonData);
            if (tmpBS != null) {
                this.backButtonStyle = tmpBS;
            }
            if ((tmpBS = UIUtils.readButtonStyle("cancelButtonStyle", json, jsonData)) != null) {
                this.cancelButtonStyle = tmpBS;
            }
            if ((tmpBS = UIUtils.readButtonStyle("chooseButtonStyle", json, jsonData)) != null) {
                this.chooseButtonStyle = tmpBS;
            }
            if ((tmpBS = UIUtils.readButtonStyle("openButtonStyle", json, jsonData)) != null) {
                this.openButtonStyle = tmpBS;
            }
            if ((tmpBS = UIUtils.readButtonStyle("parentButtonStyle", json, jsonData)) != null) {
                this.parentButtonStyle = tmpBS;
            }
            this.contentsStyle = json.readValue("contentsStyle", List.ListStyle.class, jsonData);
            this.pathFieldStyle = json.readValue("pathFieldStyle", TextField.TextFieldStyle.class, jsonData);
            if (jsonData.has("contentsPaneStyle")) {
                this.contentsPaneStyle = json.readValue("contentsPaneStyle", ScrollPane.ScrollPaneStyle.class, jsonData);
            }
            if (jsonData.has("space")) {
                this.space = json.readValue("space", Float.TYPE, jsonData).floatValue();
            }
        }
    }
}

