/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pools;
import net.dermetfan.utils.math.MathUtils;

public class ScrollPaneSnapAction
extends Action {
    private Value anchorX;
    private Value anchorY;
    private Indicator indicator;
    private boolean indicateVertical;
    private final FloatArray slots = new FloatArray();
    private final SlotSearchEvent searchEvent = new SlotSearchEvent(){
        {
            this.setBubbles(false);
        }
    };
    private ScrollPane pane;
    private boolean snapOutFired = true;
    private boolean snapOutCancelled;
    private boolean snapped;
    private float visualScrollX = Float.NaN;
    private float visualScrollY = Float.NaN;

    public ScrollPaneSnapAction() {
        this(Value.percentWidth(0.5f), Value.percentHeight(0.5f));
    }

    public ScrollPaneSnapAction(Value anchorX, Value anchorY) {
        this.anchorX = anchorX;
        this.anchorY = anchorY;
    }

    @Override
    public boolean act(float delta) {
        if (this.pane == null) {
            return false;
        }
        boolean cancelSnapping = false;
        if (this.pane.isDragging() || this.pane.isPanning()) {
            this.snapped = false;
            if (!this.snapOutFired) {
                SnapEvent event = Pools.obtain(SnapEvent.class);
                event.init(this, SnapEvent.Type.Out, this.getSnappedSlotX(), this.getSnappedSlotY());
                this.snapOutCancelled = this.pane.fire(event);
                if (this.snapOutCancelled) {
                    this.snap0(this.getSnappedSlotX(), this.getSnappedSlotY());
                    this.pane.cancel();
                }
                Pools.free(event);
                this.snapOutFired = true;
            }
            cancelSnapping = true;
        }
        if (!cancelSnapping && (this.snapped |= this.snapOutCancelled)) {
            this.snapOutCancelled = false;
            this.snapOutFired = false;
            cancelSnapping = true;
        }
        boolean slotsUpdated = false;
        if (!cancelSnapping) {
            this.updateSlots();
            slotsUpdated = true;
            this.snapClosest();
        }
        if (this.indicator != null && (this.pane.getVisualScrollX() != this.visualScrollX || this.pane.getVisualScrollY() != this.visualScrollY)) {
            if (!slotsUpdated) {
                this.updateSlots();
            }
            this.visualScrollX = this.pane.getVisualScrollX();
            this.visualScrollY = this.pane.getVisualScrollY();
            float currentSlot = this.indicateVertical ? this.getSnappedSlotY() : this.getSnappedSlotX();
            int pages = this.slots.size / 2;
            int page = -1;
            float closestSmaller = Float.NEGATIVE_INFINITY;
            float closestGreater = Float.POSITIVE_INFINITY;
            for (int n = 0; n < pages; ++n) {
                int i = n * 2 + (this.indicateVertical ? 1 : 0);
                float slot = this.slots.get(i);
                float diff = currentSlot - slot;
                if (diff >= 0.0f) {
                    if (diff <= currentSlot - closestSmaller) {
                        closestSmaller = slot;
                    }
                } else if (diff >= currentSlot - closestGreater) {
                    closestGreater = slot;
                }
                if (!(slot <= currentSlot)) continue;
                ++page;
            }
            assert (page > -1 || pages == 0);
            assert (page != pages);
            this.indicator.indicate(this, page, pages, MathUtils.replaceNaN((currentSlot - closestSmaller) / (closestGreater - closestSmaller), 1.0f));
        }
        return false;
    }

    @Override
    public void setTarget(Actor target) {
        super.setTarget(target);
        if (target instanceof ScrollPane) {
            this.pane = (ScrollPane)target;
            this.dirtyIndicator();
        } else if (target == null) {
            this.pane = null;
            if (this.indicator != null) {
                this.indicator.indicate(this, 0, 0, 0.0f);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.anchorX = Value.percentWidth(0.5f);
        this.anchorY = Value.percentHeight(0.5f);
        this.indicator = null;
        this.indicateVertical = false;
        this.slots.clear();
        this.searchEvent.reset();
        this.pane = null;
        this.snapOutFired = true;
        this.snapOutCancelled = false;
        this.snapped = false;
        this.visualScrollX = Float.NaN;
        this.visualScrollY = Float.NaN;
    }

    public void updateSlots() {
        this.slots.clear();
        this.findSlots(this.pane.getWidget());
    }

    private void findSlots(Actor root) {
        this.searchEvent.setTarget(this.pane.getWidget());
        root.notify(this.searchEvent, false);
        if (root instanceof Group) {
            for (Actor child : ((Group)root).getChildren()) {
                this.findSlots(child);
            }
        }
    }

    public void reportSlot(float x, float y) {
        this.slots.ensureCapacity(2);
        this.slots.add(x);
        this.slots.add(y);
        this.dirtyIndicator();
    }

    public boolean findClosestSlot(Vector2 slot) {
        float anchorX = this.anchorX.get(this.pane) + this.pane.getVisualScrollX();
        float anchorY = this.anchorY.get(this.pane) + this.pane.getVisualScrollY();
        float closestDistance = Float.POSITIVE_INFINITY;
        boolean found = false;
        for (int i = 1; i < this.slots.size; i += 2) {
            float slotY;
            float slotX = this.slots.get(i - 1);
            float distance = Vector2.dst2(anchorX, anchorY, slotX, slotY = this.slots.get(i));
            if (!(distance <= closestDistance)) continue;
            closestDistance = distance;
            slot.set(slotX, slotY);
            found = true;
        }
        return found;
    }

    private void snapClosest() {
        Vector2 vec2 = Pools.obtain(Vector2.class);
        if (this.findClosestSlot(vec2)) {
            this.snap(vec2.x, vec2.y);
        } else {
            this.snap(this.getSnappedSlotX(), this.getSnappedSlotY());
        }
        Pools.free(vec2);
    }

    public void snap(Slot slot, Actor actor) {
        Vector2 vec2 = Pools.obtain(Vector2.class);
        slot.getSlot(actor, vec2);
        this.snap(vec2);
        Pools.free(vec2);
    }

    public void snap(Vector2 slot) {
        this.snap(slot.x, slot.y);
    }

    public void snap(float slotX, float slotY) {
        SnapEvent event = Pools.obtain(SnapEvent.class);
        if (!this.snapOutFired) {
            event.init(this, SnapEvent.Type.Out, this.getSnappedSlotX(), this.getSnappedSlotY());
            this.snapOutCancelled = this.pane.fire(event);
            this.snapOutFired = true;
            if (this.snapOutCancelled) {
                Pools.free(event);
                return;
            }
        }
        event.init(this, SnapEvent.Type.In, slotX, slotY);
        if (!this.pane.fire(event)) {
            this.snap0(slotX, slotY);
            this.snapped = true;
            this.snapOutFired = false;
        }
        Pools.free(event);
    }

    private void snap0(float slotX, float slotY) {
        this.pane.fling(0.0f, 0.0f, 0.0f);
        this.pane.setScrollX(slotX - this.anchorX.get(this.pane));
        this.pane.setScrollY(slotY - this.anchorY.get(this.pane));
    }

    public void dirtyIndicator() {
        this.visualScrollY = Float.NaN;
        this.visualScrollX = Float.NaN;
    }

    public float getSnappedSlotX() {
        return this.pane.getScrollX() + this.anchorX.get(this.pane);
    }

    public float getSnappedSlotY() {
        return this.pane.getScrollY() + this.anchorY.get(this.pane);
    }

    public Value getAnchorX() {
        return this.anchorX;
    }

    public void setAnchorX(Value anchorX) {
        this.anchorX = anchorX;
    }

    public Value getAnchorY() {
        return this.anchorY;
    }

    public void setAnchorY(Value anchorY) {
        this.anchorY = anchorY;
    }

    public void setAnchor(Value anchorX, Value anchorY) {
        this.anchorX = anchorX;
        this.anchorY = anchorY;
    }

    public Indicator getIndicator() {
        return this.indicator;
    }

    public void setIndicator(Indicator indicator) {
        this.indicator = indicator;
    }

    public boolean isIndicateVertical() {
        return this.indicateVertical;
    }

    public void setIndicateVertical(boolean indicateVertical) {
        this.indicateVertical = indicateVertical;
    }

    public FloatArray getSlots() {
        return this.slots;
    }

    public boolean isSnapped() {
        return this.snapped;
    }

    private class SlotSearchEvent
    extends Event {
        private SlotSearchEvent() {
        }

        public ScrollPaneSnapAction getAction() {
            return ScrollPaneSnapAction.this;
        }

        public ScrollPane getScrollPane() {
            assert (this.getTarget().getParent() instanceof ScrollPane) : "SlotSearchEvent#getTarget() must be ScrollPane#getWidget()";
            return (ScrollPane)this.getTarget().getParent();
        }

        public void reportSlot(float x, float y) {
            Vector2 vec2 = Pools.obtain(Vector2.class);
            this.getListenerActor().localToAscendantCoordinates(this.getScrollPane().getWidget(), vec2.set(x, y));
            this.getAction().reportSlot(vec2.x, vec2.y);
            Pools.free(vec2);
        }
    }

    public static class SnapEvent
    extends Event {
        private ScrollPaneSnapAction action;
        private Type type;
        private float slotX;
        private float slotY;

        private void init(ScrollPaneSnapAction action, Type type, float slotX, float slotY) {
            this.action = action;
            this.type = type;
            this.slotX = slotX;
            this.slotY = slotY;
        }

        @Override
        public void reset() {
            super.reset();
            this.action = null;
            this.type = null;
            this.slotX = 0.0f;
            this.slotY = 0.0f;
        }

        public ScrollPane getScrollPane() {
            assert (this.getListenerActor() instanceof ScrollPane);
            return (ScrollPane)this.getListenerActor();
        }

        public ScrollPaneSnapAction getAction() {
            return this.action;
        }

        public Type getType() {
            return this.type;
        }

        public float getSlotX() {
            return this.slotX;
        }

        public float getSlotY() {
            return this.slotY;
        }

        public static enum Type {
            In,
            Out;

        }
    }

    public static interface Indicator {
        public void indicate(ScrollPaneSnapAction var1, int var2, int var3, float var4);
    }

    public static abstract class Slot
    implements EventListener {
        @Override
        public boolean handle(Event e) {
            if (e instanceof SlotSearchEvent) {
                SlotSearchEvent event = (SlotSearchEvent)e;
                Vector2 vec2 = Pools.obtain(Vector2.class);
                this.getSlot(event.getListenerActor(), vec2);
                event.reportSlot(vec2.x, vec2.y);
                Pools.free(vec2);
            }
            return false;
        }

        public abstract void getSlot(Actor var1, Vector2 var2);
    }

    public static class ValueSlot
    extends Slot {
        private Value valueX;
        private Value valueY;

        public ValueSlot(Value valueX, Value valueY) {
            this.valueX = valueX;
            this.valueY = valueY;
        }

        @Override
        public void getSlot(Actor actor, Vector2 slot) {
            slot.set(this.valueX.get(actor), this.valueY.get(actor));
        }

        public Value getValueX() {
            return this.valueX;
        }

        public void setValueX(Value valueX) {
            this.valueX = valueX;
        }

        public Value getValueY() {
            return this.valueY;
        }

        public void setValueY(Value valueY) {
            this.valueY = valueY;
        }
    }

    public static class AlignSlot
    extends Slot {
        private int align;

        public AlignSlot(int align) {
            this.align = align;
        }

        @Override
        public void getSlot(Actor actor, Vector2 slot) {
            slot.set(actor.getX(this.align) - actor.getX(), actor.getY(this.align) - actor.getY());
        }

        public int getAlign() {
            return this.align;
        }

        public void setAlign(int align) {
            this.align = align;
        }
    }
}

