/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.utils;

import com.badlogic.gdx.utils.ObjectMap;
import net.dermetfan.gdx.utils.ArrayPool;
import net.dermetfan.gdx.utils.FloatArrayPool;
import net.dermetfan.gdx.utils.IntArrayPool;
import net.dermetfan.gdx.utils.ReflectionArrayPool;

public class ArrayPools {
    private static final ObjectMap<Class, ArrayPool> typePools = new ObjectMap();
    private static FloatArrayPool floatPool;
    private static IntArrayPool intPool;

    public static <T> ArrayPool<T> get(Class<T> type, int max, int maxEach) {
        ReflectionArrayPool<T> pool = typePools.get(type);
        if (pool == null) {
            pool = new ReflectionArrayPool<T>(type, max, maxEach);
            typePools.put(type, pool);
        }
        return pool;
    }

    public static FloatArrayPool getFloats(int max, int maxEach) {
        if (floatPool == null) {
            floatPool = new FloatArrayPool(max, maxEach);
        }
        return floatPool;
    }

    public static IntArrayPool getInts(int max, int maxEach) {
        if (intPool == null) {
            intPool = new IntArrayPool(max, maxEach);
        }
        return intPool;
    }

    public static <T> ArrayPool<T> get(Class<T> type) {
        return ArrayPools.get(type, -1, 100);
    }

    public static FloatArrayPool getFloats() {
        return ArrayPools.getFloats(-1, 100);
    }

    public static IntArrayPool getInts() {
        return ArrayPools.getInts(-1, 100);
    }

    public static <T> void set(Class<T> type, ArrayPool<T> pool) {
        typePools.put(type, pool);
    }

    public static void set(FloatArrayPool pool) {
        floatPool = pool;
    }

    public static void set(IntArrayPool pool) {
        intPool = pool;
    }

    public static <T> T[] obtain(Class<T> type, int length) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot return primitive array without boxing. Use obtain" + (type == Float.TYPE ? "Float" : (type == Integer.TYPE ? "Int" : "[Type]")) + "s(int) instead.");
        }
        return ArrayPools.get(type).obtain(length);
    }

    public static float[] obtainFloats(int length) {
        return ArrayPools.getFloats().obtain(length);
    }

    public static int[] obtainInts(int length) {
        return ArrayPools.getInts().obtain(length);
    }

    public static <T> void free(T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("array cannot be null");
        }
        ArrayPool<?> pool = ArrayPools.get(array.getClass().getComponentType());
        pool.free(array);
    }

    public static void free(float[] array) {
        ArrayPools.getFloats().free(array);
    }

    public static void free(int[] array) {
        ArrayPools.getInts().free(array);
    }

    private ArrayPools() {
    }
}

