/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.utils;

import com.badlogic.gdx.utils.ObjectMap;

public class DualObjectMap<K, V> {
    private final ObjectMap<K, V> keyToValue;
    private final ObjectMap<V, K> valueToKey;

    public DualObjectMap() {
        this.keyToValue = new ObjectMap();
        this.valueToKey = new ObjectMap();
    }

    public DualObjectMap(int initialCapacity) {
        this.keyToValue = new ObjectMap(initialCapacity);
        this.valueToKey = new ObjectMap(initialCapacity);
    }

    public DualObjectMap(int initialCapacity, float loadFactor) {
        this.keyToValue = new ObjectMap(initialCapacity, loadFactor);
        this.valueToKey = new ObjectMap(initialCapacity, loadFactor);
    }

    public DualObjectMap(ObjectMap<K, V> map) {
        this.keyToValue = new ObjectMap<K, V>(map);
        this.valueToKey = new ObjectMap(map.size);
        for (Object key : map.keys()) {
            this.valueToKey.put(map.get(key), key);
        }
    }

    public DualObjectMap(DualObjectMap<K, V> map) {
        this.keyToValue = new ObjectMap<K, V>(map.keyToValue);
        this.valueToKey = new ObjectMap<K, V>(map.valueToKey);
    }

    public void put(K key, V value) {
        this.keyToValue.put(key, value);
        this.valueToKey.put(value, key);
    }

    public K getKey(V value) {
        K key = this.valueToKey.get(value);
        assert (key != null);
        return key;
    }

    public V getValue(K key) {
        V value = this.keyToValue.get(key);
        assert (value != null);
        return value;
    }

    public V removeKey(K key) {
        V value = this.keyToValue.remove(key);
        assert (value != null);
        K removed = this.valueToKey.remove(value);
        assert (removed != null);
        return value;
    }

    public K removeValue(V value) {
        K key = this.valueToKey.remove(value);
        assert (key != null);
        V oldObject = this.keyToValue.remove(key);
        assert (oldObject != null);
        return key;
    }

    public ObjectMap<K, V> getKeyToValue() {
        return this.keyToValue;
    }

    public ObjectMap<V, K> getValueToKey() {
        return this.valueToKey;
    }
}

