/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.utils.math;

import net.dermetfan.utils.ArrayUtils;
import net.dermetfan.utils.math.MathUtils;

public class GeometryUtils {
    private static float[] floats = new float[127];

    public static void setFloats(float[] floats) {
        GeometryUtils.floats = floats;
    }

    public static float[] getFloats() {
        return floats;
    }

    public static boolean between(float x, float y, float aX, float aY, float bX, float bY, boolean inclusive) {
        return MathUtils.det(x, y, aX, aY, bX, bY) == 0.0f && MathUtils.between(x, aX, bX, inclusive) && MathUtils.between(y, aY, bY, inclusive);
    }

    public static boolean between(float x, float y, float aX, float aY, float bX, float bY) {
        return GeometryUtils.between(x, y, aX, aY, bX, bY, true);
    }

    public static float[] add(float[] items, int offset, int length, float x, float y) {
        for (int i = offset + 1; i < offset + length; i += 2) {
            int n = i - 1;
            items[n] = items[n] + x;
            int n2 = i;
            items[n2] = items[n2] + y;
        }
        return items;
    }

    public static float[] add(float[] vertices, float x, float y) {
        return GeometryUtils.add(vertices, 0, vertices.length, x, y);
    }

    public static float[] sub(float[] items, int offset, int length, float x, float y) {
        return GeometryUtils.add(items, offset, length, -x, -y);
    }

    public static float[] sub(float[] items, float x, float y) {
        return GeometryUtils.sub(items, 0, items.length, x, y);
    }

    public static float[] addX(float[] items, int offset, int length, float value) {
        return GeometryUtils.add(items, offset, length, value, 0.0f);
    }

    public static float[] addX(float[] items, float value) {
        return GeometryUtils.addX(items, 0, items.length, value);
    }

    public static float[] addY(float[] items, int offset, int length, float value) {
        return GeometryUtils.add(items, offset, length, 0.0f, value);
    }

    public static float[] addY(float[] items, float value) {
        return GeometryUtils.addY(items, 0, items.length, value);
    }

    public static float[] subX(float[] items, int offset, int length, float value) {
        return GeometryUtils.sub(items, offset, length, value, 0.0f);
    }

    public static float[] subX(float[] items, float value) {
        return GeometryUtils.subX(items, 0, items.length, value);
    }

    public static float[] subY(float[] items, int offset, int length, float value) {
        return GeometryUtils.sub(items, offset, length, 0.0f, value);
    }

    public static float[] subY(float[] items, float value) {
        return GeometryUtils.subY(items, 0, items.length, value);
    }

    public static float[] mul(float[] items, int offset, int length, float factorX, float factorY) {
        for (int i = offset; i < offset + length; i += 2) {
            int n = i;
            items[n] = items[n] * factorX;
            int n2 = i + 1;
            items[n2] = items[n2] * factorY;
        }
        return items;
    }

    public static float[] mul(float[] items, float factorX, float factorY) {
        return GeometryUtils.mul(items, 0, items.length, factorX, factorY);
    }

    public static float[] mulX(float[] items, int offset, int length, float factor) {
        return GeometryUtils.mul(items, offset, length, factor, 1.0f);
    }

    public static float[] mulX(float[] items, float factor) {
        return GeometryUtils.mulX(items, 0, items.length, factor);
    }

    public static float[] mulY(float[] items, int offset, int length, float factor) {
        return GeometryUtils.mul(items, offset, length, 1.0f, factor);
    }

    public static float[] mulY(float[] items, float factor) {
        return GeometryUtils.mulY(items, 0, items.length, factor);
    }

    public static float[] div(float[] items, int offset, int length, float divisorX, float divisorY) {
        for (int i = offset; i < offset + length; i += 2) {
            int n = i;
            items[n] = items[n] / divisorX;
            int n2 = i + 1;
            items[n2] = items[n2] / divisorY;
        }
        return items;
    }

    public static float[] div(float[] items, float divisorX, float divisorY) {
        return GeometryUtils.div(items, 0, items.length, divisorX, divisorY);
    }

    public static float[] divX(float[] items, int offset, int length, float divisor) {
        return GeometryUtils.div(items, offset, length, divisor, 1.0f);
    }

    public static float[] divX(float[] items, float divisor) {
        return GeometryUtils.divX(items, 0, items.length, divisor);
    }

    public static float[] divY(float[] items, int offset, int length, float divisor) {
        return GeometryUtils.div(items, offset, length, 1.0f, divisor);
    }

    public static float[] divY(float[] items, float divisor) {
        return GeometryUtils.divY(items, 0, items.length, divisor);
    }

    public static float width(float[] vertices, int offset, int length) {
        return MathUtils.amplitude2(GeometryUtils.filterX(vertices, offset, length, floats), 0, length / 2);
    }

    public static float width(float[] vertices) {
        return GeometryUtils.width(vertices, 0, vertices.length);
    }

    public static float height(float[] vertices, int offset, int length) {
        return MathUtils.amplitude2(GeometryUtils.filterY(vertices, offset, length, floats), 0, length / 2);
    }

    public static float height(float[] vertices) {
        return GeometryUtils.height(vertices, 0, vertices.length);
    }

    public static float depth(float[] vertices, int offset, int length) {
        return MathUtils.amplitude2(GeometryUtils.filterZ(vertices, offset, length, floats), 0, length / 3);
    }

    public static float depth(float[] vertices) {
        return GeometryUtils.depth(vertices, 0, vertices.length);
    }

    public static float[] filterX(float[] vertices, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return ArrayUtils.select(vertices, offset, length, -1, 2, dest, destOffset);
    }

    public static float[] filterX(float[] vertices, int offset, int length, float[] dest) {
        return GeometryUtils.filterX(vertices, offset, length, dest, 0);
    }

    public static float[] filterX(float[] vertices, float[] dest) {
        return GeometryUtils.filterX(vertices, 0, vertices.length, dest);
    }

    public static float[] filterX(float[] vertices, int offset, int length) {
        return GeometryUtils.filterX(vertices, offset, length, new float[length / 2]);
    }

    public static float[] filterX(float[] vertices) {
        return GeometryUtils.filterX(vertices, new float[vertices.length / 2]);
    }

    public static float[] filterY(float[] vertices, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return ArrayUtils.select(vertices, offset, length, 0, 2, dest, destOffset);
    }

    public static float[] filterY(float[] vertices, int offset, int length, float[] dest) {
        return GeometryUtils.filterY(vertices, offset, length, dest, 0);
    }

    public static float[] filterY(float[] vertices, float[] dest) {
        return GeometryUtils.filterY(vertices, 0, vertices.length, dest);
    }

    public static float[] filterY(float[] vertices, int offset, int length) {
        return GeometryUtils.filterY(vertices, offset, length, new float[length / 2]);
    }

    public static float[] filterY(float[] vertices) {
        return GeometryUtils.filterY(vertices, new float[vertices.length / 2]);
    }

    public static float[] filterZ(float[] vertices, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return ArrayUtils.select(vertices, offset, length, 0, 3, dest, destOffset);
    }

    public static float[] filterZ(float[] vertices, int offset, int length, float[] dest) {
        return GeometryUtils.filterZ(vertices, offset, length, dest, 0);
    }

    public static float[] filterZ(float[] vertices, float[] dest) {
        return GeometryUtils.filterZ(vertices, 0, vertices.length, dest);
    }

    public static float[] filterZ(float[] vertices, int offset, int length) {
        return GeometryUtils.filterZ(vertices, offset, length, new float[length / 3]);
    }

    public static float[] filterZ(float[] vertices) {
        return GeometryUtils.filterZ(vertices, new float[vertices.length / 3]);
    }

    public static float[] filterW(float[] vertices, int offset, int length, float[] dest, int destOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return ArrayUtils.select(vertices, offset, length, 0, 4, dest, destOffset);
    }

    public static float[] filterW(float[] vertices, int offset, int length, float[] dest) {
        return GeometryUtils.filterW(vertices, offset, length, dest, 0);
    }

    public static float[] filterW(float[] vertices, float[] dest) {
        return GeometryUtils.filterW(vertices, 0, vertices.length, dest);
    }

    public static float[] filterW(float[] vertices, int offset, int length) {
        return GeometryUtils.filterW(vertices, offset, length, new float[length / 4]);
    }

    public static float[] filterW(float[] vertices) {
        return GeometryUtils.filterW(vertices, new float[vertices.length / 4]);
    }

    public static float minX(float[] vertices, int offset, int length) {
        return MathUtils.min(GeometryUtils.filterX(vertices, offset, length, floats), 0, length / 2);
    }

    public static float minX(float[] vertices) {
        return GeometryUtils.minX(vertices, 0, vertices.length);
    }

    public static float minY(float[] vertices, int offset, int length) {
        return MathUtils.min(GeometryUtils.filterY(vertices, offset, length, floats), 0, length / 2);
    }

    public static float minY(float[] vertices) {
        return GeometryUtils.minY(vertices, 0, vertices.length);
    }

    public static float maxX(float[] vertices, int offset, int length) {
        return MathUtils.max(GeometryUtils.filterX(vertices, offset, length, floats), 0, length / 2);
    }

    public static float maxX(float[] vertices) {
        return GeometryUtils.maxX(vertices, 0, vertices.length);
    }

    public static float maxY(float[] vertices, int offset, int length) {
        return MathUtils.max(GeometryUtils.filterY(vertices, offset, length, floats), 0, length / 2);
    }

    public static float maxY(float[] vertices) {
        return GeometryUtils.maxY(vertices, 0, vertices.length);
    }

    public static float distance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt(GeometryUtils.distance2(x1, y1, x2, y2));
    }

    public static float distance2(float x1, float y1, float x2, float y2) {
        float x_dist = x2 - x1;
        float y_dist = y2 - y1;
        return x_dist * x_dist + y_dist * y_dist;
    }

    public static float[] scale(float[] vertices, int offset, int length, float minX, float minY, float maxX, float maxY) {
        GeometryUtils.divX(vertices, offset, length, GeometryUtils.width(vertices, offset, length) / (maxX - minX));
        GeometryUtils.addX(vertices, offset, length, minX - GeometryUtils.minX(vertices, offset, length));
        GeometryUtils.divY(vertices, offset, length, GeometryUtils.height(vertices, offset, length) / (maxY - minY));
        GeometryUtils.addY(vertices, offset, length, minY - GeometryUtils.minY(vertices, offset, length));
        return vertices;
    }

    public static float[] scale(float[] vertices, float minX, float minY, float maxX, float maxY) {
        return GeometryUtils.scale(vertices, 0, vertices.length, minX, minY, maxX, maxY);
    }

    public static float[] reverse(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        int i = offset;
        int ii = offset + length - 2;
        while (i < offset + length / 2) {
            float ix = vertices[i];
            float iy = vertices[i + 1];
            float iix = vertices[ii];
            float iiy = vertices[ii + 1];
            vertices[i] = iix;
            vertices[i + 1] = iiy;
            vertices[ii] = ix;
            vertices[ii + 1] = iy;
            i += 2;
            ii -= 2;
        }
        return vertices;
    }

    public static float[] reverse(float[] vertices) {
        return GeometryUtils.reverse(vertices, 0, vertices.length);
    }

    public static float[] reverse3D(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        int i = offset;
        int ii = offset + length - 3;
        while (i < offset + length / 2) {
            float ix = vertices[i];
            float iy = vertices[i + 1];
            float iz = vertices[i + 2];
            float iix = vertices[ii];
            float iiy = vertices[ii + 1];
            float iiz = vertices[ii + 2];
            vertices[i] = iix;
            vertices[i + 1] = iiy;
            vertices[i + 2] = iiz;
            vertices[ii] = ix;
            vertices[ii + 1] = iy;
            vertices[ii + 2] = iz;
            i += 3;
            ii -= 3;
        }
        return vertices;
    }

    public static float[] reverse3D(float[] vertices) {
        return GeometryUtils.reverse3D(vertices, 0, vertices.length);
    }

    public static int closePoints(float x, float y, float maxDistance2, float[] vertices, int offset, int length, float[] output, int outputOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        int outputIndex = outputOffset;
        for (int i = offset; i < offset + length; i += 2) {
            float pX = vertices[i];
            float pY = vertices[i + 1];
            if (!(GeometryUtils.distance2(x, y, pX, pY) <= maxDistance2)) continue;
            if (output != null) {
                output[outputIndex] = pX;
                output[outputIndex + 1] = pY;
            }
            outputIndex += 2;
        }
        return (outputIndex - outputOffset) / 2;
    }

    public static int closePoints(float x, float y, float deltaX, float deltaY, float[] vertices, int offset, int length, float[] output, int outputOffset) {
        ArrayUtils.checkRegion(vertices, offset, length);
        int outputIndex = outputOffset;
        for (int i = offset; i < offset + length; i += 2) {
            float pX = vertices[i];
            float pY = vertices[i + 1];
            if (!(Math.abs(pX - x) <= deltaX) || !(Math.abs(pY - y) <= deltaY)) continue;
            if (output != null) {
                output[outputIndex] = pX;
                output[outputIndex + 1] = pY;
            }
            outputIndex += 2;
        }
        return (outputIndex - outputOffset) / 2;
    }

    public static void sortPoints(float[] vertices, boolean byY) {
        GeometryUtils.sortPoints(vertices, 0, vertices.length, byY);
    }

    public static void sortPoints(float[] vertices, int offset, int length, boolean byY) {
        int i;
        ArrayUtils.checkRegion(vertices, offset, length);
        int y = byY ? 1 : 0;
        int smallest = offset;
        for (int i2 = offset; i2 < offset + length; i2 += 2) {
            if (!(vertices[i2 + y] < vertices[smallest + y])) continue;
            smallest = i2;
        }
        int greatest = offset;
        for (i = offset; i < offset + length; i += 2) {
            if (!(vertices[i + y] > vertices[greatest + y])) continue;
            greatest = i;
        }
        GeometryUtils.floats[0] = vertices[smallest];
        GeometryUtils.floats[1] = vertices[smallest + 1];
        i = smallest;
        for (int fi = 2; fi < length; fi += 2) {
            int next = greatest;
            float coord = vertices[i + y];
            for (int ii = offset; ii < offset + length; ii += 2) {
                int coord2InVertices;
                int coord2InFloats;
                float coord2;
                if (ii == i || (coord2 = vertices[ii + y]) < coord || !(coord2 - coord <= vertices[next + y] - coord) || (coord2InFloats = GeometryUtils.closePoints(coord2, coord2, byY ? Float.POSITIVE_INFINITY : 0.0f, byY ? 0.0f : Float.POSITIVE_INFINITY, floats, 0, fi, null, 0)) > 0 && coord2InFloats >= (coord2InVertices = GeometryUtils.closePoints(coord2, coord2, byY ? Float.POSITIVE_INFINITY : 0.0f, byY ? 0.0f : Float.POSITIVE_INFINITY, vertices, offset, length, null, 0))) continue;
                next = ii;
            }
            GeometryUtils.floats[fi] = vertices[next];
            GeometryUtils.floats[fi + 1] = vertices[next + 1];
            i = next;
        }
        System.arraycopy(floats, 0, vertices, offset, length);
    }

    public static void arrangeConvexPolygon(float[] vertices, boolean clockwise) {
        GeometryUtils.arrangeConvexPolygon(vertices, 0, vertices.length, clockwise);
    }

    public static void arrangeConvexPolygon(float[] vertices, int offset, int length, boolean clockwise) {
        int i;
        ArrayUtils.checkRegion(vertices, offset, length);
        if (length % 2 != 0) {
            throw new IllegalArgumentException("malformed vertices, length is odd: " + length);
        }
        if (length <= 4) {
            return;
        }
        GeometryUtils.sortPoints(vertices, offset, length, false);
        System.arraycopy(vertices, 0, floats, 0, offset + length);
        int ltI = i = offset + 2;
        int gtI = offset + length - 2;
        while (i < offset + length) {
            float x = floats[i];
            float y = floats[i + 1];
            float det = MathUtils.det(floats[offset], floats[offset + 1], floats[offset + length - 2], floats[offset + length - 1], x, y);
            if (clockwise ? det > 0.0f : det < 0.0f) {
                vertices[ltI++] = x;
                vertices[ltI++] = y;
            } else {
                vertices[gtI] = x;
                vertices[gtI + 1] = y;
                gtI -= 2;
            }
            i += 2;
        }
    }

    public static float polygonArea(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        if (length % 2 != 0) {
            throw new IllegalArgumentException("malformed vertices, length is odd: " + length);
        }
        float area = 0.0f;
        for (int i = offset; i < offset + length; i += 2) {
            float x = vertices[i];
            float y = vertices[i + 1];
            float x2 = vertices[ArrayUtils.repeat(offset, length, i + 2)];
            float y2 = vertices[ArrayUtils.repeat(offset, length, i + 3)];
            area += x * y2;
            area -= y * x2;
        }
        return area / 2.0f;
    }

    public static boolean areVerticesClockwise(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        return length <= 4 || GeometryUtils.polygonArea(vertices, offset, length) < 0.0f;
    }

    public static boolean areVerticesClockwise(float[] vertices) {
        return GeometryUtils.areVerticesClockwise(vertices, 0, vertices.length);
    }

    public static boolean isConvex(float[] vertices) {
        return GeometryUtils.isConvex(vertices, 0, vertices.length);
    }

    public static boolean isConvex(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        int direction = 0;
        for (int i = offset; i < offset + length; i += 2) {
            int dir;
            float det = MathUtils.det(vertices[i], vertices[i + 1], vertices[ArrayUtils.repeat(offset, length, i + 2)], vertices[ArrayUtils.repeat(offset, length, i + 3)], vertices[ArrayUtils.repeat(offset, length, i + 4)], vertices[ArrayUtils.repeat(offset, length, i + 5)]);
            int n = det > 0.0f ? 1 : (dir = det < 0.0f ? -1 : 0);
            if (i != offset && dir != direction) {
                return false;
            }
            direction = dir;
        }
        return true;
    }

    public static float[] rotate(float x, float y, float width, float height, float radians, float[] output, int offset) {
        if (output == null || offset + 8 > output.length - 1) {
            output = new float[8];
        }
        float rad = (float)(Math.sqrt(height * height + width * width) / 2.0);
        float theta = (float)Math.atan2(height, width);
        float x0 = (float)((double)rad * Math.cos(theta + radians));
        float y0 = (float)((double)rad * Math.sin(theta + radians));
        float x1 = (float)((double)rad * Math.cos(-theta + radians));
        float y1 = (float)((double)rad * Math.sin(-theta + radians));
        float offsetX = x + width / 2.0f;
        float offsetY = y + height / 2.0f;
        output[offset] = offsetX + x0;
        output[offset + 1] = offsetY + y0;
        output[offset + 2] = offsetX + x1;
        output[offset + 3] = offsetY + y1;
        output[offset + 4] = offsetX - x0;
        output[offset + 5] = offsetY - y0;
        output[offset + 6] = offsetX - x1;
        output[offset + 7] = offsetY - y1;
        return output;
    }

    public static float invertAxis(float coord, float axisSize) {
        return MathUtils.mirror(coord, axisSize / 2.0f);
    }

    public static float[] invertAxes(float[] vertices, int offset, int length, boolean x, boolean y) {
        if (!x && !y) {
            return vertices;
        }
        float height = GeometryUtils.height(vertices, offset, length);
        float width = GeometryUtils.width(vertices, offset, length);
        for (int i = (x ? 0 : 1) + offset; i < offset + length; i += x ^ y ? 2 : 1) {
            vertices[i] = i % 2 == 0 ? GeometryUtils.invertAxis(vertices[i], width) : GeometryUtils.invertAxis(vertices[i], height);
        }
        return vertices;
    }

    public static float[] invertAxes(float[] vertices, boolean x, boolean y) {
        return GeometryUtils.invertAxes(vertices, 0, vertices.length, x, y);
    }

    public static float[] toYDown(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        GeometryUtils.invertAxes(vertices, offset, length, false, true);
        return GeometryUtils.subY(vertices, offset, length, GeometryUtils.height(vertices, offset, length));
    }

    public static float[] toYDown(float[] vertices) {
        return GeometryUtils.toYDown(vertices, 0, vertices.length);
    }

    public static float[] toYUp(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion(vertices, offset, length);
        GeometryUtils.invertAxes(vertices, offset, length, false, true);
        return GeometryUtils.subY(vertices, offset, length, GeometryUtils.height(vertices, offset, length));
    }

    public static float[] toYUp(float[] vertices) {
        return GeometryUtils.toYUp(vertices, 0, vertices.length);
    }
}

