/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.utils.math;

import java.util.Random;
import net.dermetfan.utils.ArrayUtils;
import net.dermetfan.utils.Function;
import net.dermetfan.utils.Pair;

public abstract class Noise {
    private static long seed = -1L;
    private static boolean seedEnabled;
    private static Random random;

    public static float[] midpointDisplacement(float[] values, float range, float smoothness) {
        int i = 0;
        while (i < values.length) {
            values[i] = (ArrayUtils.getRepeated(values, i - 1) + ArrayUtils.getRepeated(values, i + 1)) / 2.0f + Noise.random(-range, range);
            ++i;
            range /= smoothness;
        }
        return values;
    }

    public static float[][] midpointDisplacement(int n, float smoothness, float range, int scaleX, int scaleY) {
        return Noise.midpointDisplacement(n, range, smoothness, true, null, scaleX, scaleY);
    }

    public static float[][] midpointDisplacement(int n, float smoothness, float range, Function<Pair<Float, Float>, Float> init, int scaleX, int scaleY) {
        return Noise.midpointDisplacement(n, range, smoothness, false, init, scaleX, scaleY);
    }

    public static float[][] midpointDisplacement(int n, float smoothness, float range, float init, int scaleX, int scaleY) {
        return Noise.midpointDisplacement(n, range, smoothness, false, init, scaleX, scaleY);
    }

    public static float[][] midpointDisplacement(int n, float smoothness, float range, boolean initializeRandomly, final float init, int scaleX, int scaleY) {
        return Noise.midpointDisplacement(n, range, smoothness, initializeRandomly, initializeRandomly ? null : new Function<Pair<Float, Float>, Float>(){

            @Override
            public Float apply(Pair<Float, Float> object) {
                return Float.valueOf(init);
            }
        }, scaleX, scaleY);
    }

    private static float[][] midpointDisplacement(int n, float smoothness, float range, boolean initializeRandomly, Function<Pair<Float, Float>, Float> init, int scaleX, int scaleY) {
        int y;
        int x;
        if (n < 0) {
            throw new IllegalArgumentException("n must be >= 0: " + n);
        }
        range /= 2.0f;
        int power = (int)Math.pow(2.0, n);
        int width = scaleX * power + 1;
        int height = scaleY * power + 1;
        float[][] map = new float[width][height];
        Pair<Float, Float> coord = new Pair<Float, Float>();
        for (x = 0; x < width; x += power) {
            for (y = 0; y < height; y += power) {
                map[x][y] = initializeRandomly ? Noise.random(-range, range) : init.apply(coord.set(Float.valueOf(x), Float.valueOf(y))).floatValue();
            }
        }
        int step = power / 2;
        while (step > 0) {
            boolean sx = false;
            for (x = 0; x < width; x += step) {
                boolean sy = false;
                for (y = 0; y < height; y += step) {
                    if (sx && sy) {
                        map[x][y] = (map[x - step][y - step] + map[x + step][y - step] + map[x - step][y + step] + map[x + step][y + step]) / 4.0f + Noise.random(-range, range);
                    } else if (sx) {
                        map[x][y] = (map[x - step][y] + map[x + step][y]) / 2.0f + Noise.random(-range, range);
                    } else if (sy) {
                        map[x][y] = (map[x][y - step] + map[x][y + step]) / 2.0f + Noise.random(-range, range);
                    }
                    sy = !sy;
                }
                sx = !sx;
            }
            step /= 2;
            range /= smoothness;
        }
        return map;
    }

    public static float[][] diamondSquare(int n, float smoothness, float range, boolean wrapX, boolean wrapY, Function<Pair<Float, Float>, Float> init, int scaleX, int scaleY) {
        return Noise.diamondSquare(n, smoothness, range, wrapX, wrapY, false, init, scaleX, scaleY);
    }

    public static float[][] diamondSquare(int n, float smoothness, float range, boolean wrapX, boolean wrapY, int scaleX, int scaleY) {
        return Noise.diamondSquare(n, smoothness, range, wrapX, wrapY, true, Float.NaN, scaleX, scaleY);
    }

    public static float[][] diamondSquare(int n, float smoothness, float range, boolean wrapX, boolean wrapY, float init, int scaleX, int scaleY) {
        return Noise.diamondSquare(n, smoothness, range, wrapX, wrapY, false, init, scaleX, scaleY);
    }

    public static float[][] diamondSquare(int n, float smoothness, float range, boolean wrapX, boolean wrapY, boolean initializeRandomly, final float init, int scaleX, int scaleY) {
        return Noise.diamondSquare(n, smoothness, range, wrapX, wrapY, initializeRandomly, initializeRandomly ? null : new Function<Pair<Float, Float>, Float>(){

            @Override
            public Float apply(Pair<Float, Float> object) {
                return Float.valueOf(init);
            }
        }, scaleX, scaleY);
    }

    private static float[][] diamondSquare(int n, float smoothness, float range, boolean wrapX, boolean wrapY, boolean initializeRandomly, Function<Pair<Float, Float>, Float> init, int scaleX, int scaleY) {
        int y;
        int x;
        if (n < 0) {
            throw new IllegalArgumentException("n must be >= 0: " + n);
        }
        range /= 2.0f;
        int power = (int)Math.pow(2.0, n);
        int width = scaleX * power + 1;
        int height = scaleY * power + 1;
        float[][] map = new float[width][height];
        Pair<Float, Float> coord = new Pair<Float, Float>();
        for (x = 0; x < width; x += power) {
            for (y = 0; y < height; y += power) {
                map[x][y] = initializeRandomly ? Noise.random(-range, range) : init.apply(coord.set(Float.valueOf(x), Float.valueOf(y))).floatValue();
            }
        }
        power /= 2;
        while (power > 0) {
            for (x = power; x < width; x += power * 2) {
                for (y = power; y < height; y += power * 2) {
                    map[x][y] = (map[x - power][y - power] + map[x - power][y + power] + map[x + power][y + power] + map[x + power][y - power]) / 4.0f + Noise.random(-range, range);
                }
            }
            for (x = 0; x < width - (wrapX ? 1 : 0); x += power) {
                for (y = power * (1 - x / power % 2); y < height - (wrapY ? 1 : 0); y += power * 2) {
                    float avg = (map[ArrayUtils.repeat(width, x - power)][y] + map[ArrayUtils.repeat(width, x + power)][y] + map[x][ArrayUtils.repeat(height, y - power)] + map[x][ArrayUtils.repeat(height, y + power)]) / 4.0f;
                    map[x][y] = avg + Noise.random(-range, range);
                    if (wrapX && x == 0) {
                        map[width - 1][y] = avg;
                    }
                    if (!wrapY || y != 0) continue;
                    map[x][height - 1] = avg;
                }
            }
            power /= 2;
            range /= smoothness;
        }
        return map;
    }

    public static float random(float start, float end) {
        return start + random.nextFloat() * (end - start);
    }

    public static void setSeedEnabled(boolean seedEnabled) {
        Noise.seedEnabled = seedEnabled;
        if (Noise.seedEnabled) {
            random.setSeed(seed);
        } else {
            random = new Random();
        }
    }

    public static boolean isSeedEnabled() {
        return seedEnabled;
    }

    public static long getSeed() {
        return seed;
    }

    public static void setSeed(long seed) {
        Noise.seed = seed;
        random.setSeed(Noise.seed);
    }

    public static Random getRandom() {
        return random;
    }

    static {
        random = new Random();
    }
}

